#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <libgen.h>
#include <stdlib.h>
#include "lamps.h"
#define PAGE_SIZE 50
//Global variables
gchar TreeName[MAX_TEXT_FIELD],LeafName[MAX_PAR][MAX_TEXT_FIELD],LeafType[MAX_PAR][MAX_TEXT_FIELD],
      RootSetupFName[2090];;
gint LType[MAX_PAR],LeafMin[MAX_PAR],LeafMax[MAX_PAR],ActiveTree,Persistent,Page,LastPage;
gboolean DeleteLeaf[MAX_PAR];
GtkWidget **WPers,**WTreeN,**WNum,**WLeafN,**WLType,**WParaN,**WLeafMin,**WLeafMax,**WResl,**WKeep;
GtkWidget *BrowseBut;
struct FileSelectType *FileX;                                                                               //see open.c
gchar RFName[2090];                                                      //Name of root file browsed for tree and leaves
gboolean LeafLock;
extern enum ProgramState ProgramState;
extern struct Setup Setup;
extern gchar SetupDir[MAX_DIR_STRLEN];
extern enum ProgramState ProgramState;
extern struct FileSelectType *FileX;
extern gchar SetupDir[MAX_DIR_STRLEN],ListFDir[MAX_DIR_STRLEN];                                        //Directory prefs
extern gint TopOfset;                                         //Accounts for space occupied by window manager at the top
extern struct PsBGated PsBGated[MAX_PSEUDO];                                                  //Banana gated pseudo type
extern gint TopSpace;

//Function templates
void ParameterList(GtkWidget *W,gpointer Data); void CheckRootSetup(void);
void AllocateScreenWins(void); void AllocateMemory(void); void CheckTwod(void); void CheckOned(void);
void CalculateBitShifts(void); void CheckPseudos(void);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void Attention(gint XPos,gchar *Messg);
void CloseAllSpecWindows(GtkWidget *W,gpointer Data);
void SetOned(GtkWidget *W,gpointer Data); void SetTwod(GtkWidget *W,gpointer Data);                        //See setup.c
void N1Changed(GtkWidget *W,GtkSpinButton *Spin); void N2Changed(GtkWidget *W,GtkSpinButton *Spin);        //See setup.c
void SetPseudo(GtkWidget *W,gpointer Data); void NPChanged(GtkWidget *W,GtkSpinButton *Spin);              //See setup.c
void SpecWSz1(GtkWidget *W,gpointer Data); void SpecWSz2(GtkWidget *W,gpointer Data);                      //See setup.c
void FileOpenNew(gchar *Title,GtkWidget *Parent,gint X,gint Y,gboolean OpenToRead,gchar *StartPath,gchar *Mask,
                 gboolean MaskEditable,void (*CallBack)(GtkWidget *,gpointer),gboolean Persist);            //see open.c
void ParseTextToInt(gchar *TextBuf,gint From,gint n,gint *Val,gint *ToHere);                               //see parse.c
void ParseTextToStr(gchar *TextBuf,gint From,gchar *OutText,gint *ToHere);                                 //see parse.c
int RootFileInfo(char *);                                                                               //see root_io.cc
//----------------------------------------------------------------------------------------------------------------------
void ChangePage(GtkWidget *W,gint Incr)
{
gint i,PIndex,k;
gchar Str[255];

Page+=Incr; Page=CLAMP(Page,0,LastPage);
LeafLock=TRUE;                                                 //The gtk_entry_set_text calls below do not change values
for (i=0;i<PAGE_SIZE;++i)
   {
   PIndex=PAGE_SIZE*Page+i;
   sprintf(Str,"%3d",PIndex+1); gtk_entry_set_text(GTK_ENTRY(WNum[i]),Str);
   gtk_entry_set_text(GTK_ENTRY(WLeafN[i]),LeafName[PIndex]);
   gtk_entry_set_text(GTK_ENTRY(WLType[i]),LeafType[PIndex]);
   gtk_entry_set_text(GTK_ENTRY(WParaN[i]),Setup.Parameter.Name[PIndex]);
   sprintf(Str,"%d",LeafMin[PIndex]); gtk_entry_set_text(GTK_ENTRY(WLeafMin[i]),Str);
   sprintf(Str,"%d",LeafMax[PIndex]); gtk_entry_set_text(GTK_ENTRY(WLeafMax[i]),Str);
   k=Setup.Parameter.Chan[PIndex]/1024; sprintf(Str,"%d K",k);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(WResl[i])->entry),Str);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WKeep[i]),!DeleteLeaf[PIndex]);
   }
LeafLock=FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void TreeNameChanged(GtkWidget *W,gpointer Unused)
{ strcpy(TreeName,gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void LeafNameChanged(GtkWidget *W,gint i)
{
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   strcpy(LeafName[PIndex],gtk_entry_get_text(GTK_ENTRY(W)));
   }
}
//----------------------------------------------------------------------------------------------------------------------
void ParNameChanged(GtkWidget *W,gint i)
{
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   strcpy(Setup.Parameter.Name[PIndex],gtk_entry_get_text(GTK_ENTRY(W)));
   }
}
//----------------------------------------------------------------------------------------------------------------------
void LeafMinChanged(GtkWidget *W,gint i)
{
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   LeafMin[PIndex]=atoi(gtk_entry_get_text(GTK_ENTRY(W)));
   }
}
//----------------------------------------------------------------------------------------------------------------------
void LeafMaxChanged(GtkWidget *W,gint i)
{
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   LeafMax[PIndex]=atoi(gtk_entry_get_text(GTK_ENTRY(W)));
   }
}
//----------------------------------------------------------------------------------------------------------------------
void ReslChanged(GtkWidget *W,gint i)
{
const gchar *Str;
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   Str=gtk_entry_get_text(GTK_ENTRY(W));
   Setup.Parameter.Chan[PIndex]=4096;
   if (!strcmp(Str,"1 K")) Setup.Parameter.Chan[PIndex]=1024;
   else if (!strcmp(Str,"2 K")) Setup.Parameter.Chan[PIndex]=2048;
   else if (!strcmp(Str,"4 K")) Setup.Parameter.Chan[PIndex]=4096;
   else if (!strcmp(Str,"8 K")) Setup.Parameter.Chan[PIndex]=8192;
   else if (!strcmp(Str,"16 K")) Setup.Parameter.Chan[PIndex]=16384;
   else if (!strcmp(Str,"32 K")) Setup.Parameter.Chan[PIndex]=32768;
   else if (!strcmp(Str,"64 K")) Setup.Parameter.Chan[PIndex]=65536;
   }
}
//----------------------------------------------------------------------------------------------------------------------
void KeepLeaf(GtkWidget *CBut,gint i)
{
gint PIndex;

if (!LeafLock)
   {
   PIndex=PAGE_SIZE*Page+i;
   if (GTK_TOGGLE_BUTTON(CBut)->active) DeleteLeaf[PIndex]=FALSE; else DeleteLeaf[PIndex]=TRUE;
   }
}
//----------------------------------------------------------------------------------------------------------------------
void PersistentChanged(GtkWidget *W,gpointer Unused)
{ 
const gchar *Str;

Str=gtk_entry_get_text(GTK_ENTRY(W));
if (!strcmp(Str,"ROOT Setup")) Persistent=1; else Persistent=0;
}
//----------------------------------------------------------------------------------------------------------------------
void DelUnwantedLeaves(GtkWidget *W,gpointer Unused)
{
gint i,j,N;

for (N=0;N<MAX_PAR;++N) if (strlen(LeafName[N])==0) break;
for (i=0;i<N;++i)
   {
   if (DeleteLeaf[i])
      {
      for (j=i;j<N;++j)
         {
         strcpy(LeafName[j],LeafName[j+1]);
         strcpy(LeafType[j],LeafType[j+1]);
         LType[j]=LType[j+1];
         strcpy(Setup.Parameter.Name[j],Setup.Parameter.Name[j+1]);
         LeafMin[j]=LeafMin[j+1]; LeafMax[j]=LeafMax[j+1];
         DeleteLeaf[j]=DeleteLeaf[j+1];
         }
      --i; --N;
      }
   }
ChangePage(NULL,0);
}
//----------------------------------------------------------------------------------------------------------------------
void RootHelp(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*VBox,*Label,*But,*HBox;
static GdkColor BlueBg    = {0,0x0000,0x0000,0x0000};
static GdkColor BlueFg    = {0,0x0000,0x0000,0x9999};
GtkStyle *BlueStyle;
gint i;
static gchar *Text[7]=
   {
   "Root Setup must be done to analyse ROOT files",
   "It is not required for acquisition, even if you are writing ROOT files",
   "If you are going to analyse only ROOT data for sometime:",
   "    edit Root Setup and set ROOT Setup as Persistent",
   "When you want to go back to acquisition or analysis of zls/Candle data:",
   "    be sure to set LAMPS Setup as persistent instead of ROOT Setup"
   };

BlueStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=BlueFg; BlueStyle->bg[i]=BlueBg; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(Win),"Help Root Setup");
gtk_window_set_modal(GTK_WINDOW(Win),TRUE);
gtk_container_set_border_width(GTK_CONTAINER(Win),10);
VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox);
for (i=0;i<7;++i)
   {
   Label=gtk_label_new(Text[i]); gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,FALSE,0);
   gtk_misc_set_alignment(GTK_MISC(Label),0.0f,0.0f);
   SetStyleRecursively(Label,BlueStyle);
   }
HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_from_stock(GTK_STOCK_OK); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,10);
g_signal_connect_swapped(But,"clicked",G_CALLBACK(gtk_widget_destroy),Win);

gtk_widget_show_all(Win);
gtk_style_unref(BlueStyle);
}
//----------------------------------------------------------------------------------------------------------------------
gint OkReadRootSetup(gchar *ErrMessg,gint Opt)                   //Opt is normally 0. When Opt=1 we read .lamps_root_set
{
FILE *Fp;
gint i,j,Value[10],ToHere,L;
gchar Line[200],Str[200],Str1[XLONG_TEXT_FIELD+100];
gboolean ReadHidden;
static gchar Head[10][85] =
   {
   "--------------------------Tree Settings sarts here------------------------------",
   "---------------------------Tree Settings ends here------------------------------",
   "----------------------------Leaf List starts here-------------------------------",
   "---------------------------Leaf List Setup ends here----------------------------",
   "------------------------Oned Setup starts here----------------------------------",
   "------------------------Oned Setup ends here------------------------------------",
   "------------------------Twod Setup starts here----------------------------------",
   "------------------------Twod Setup ends here------------------------------------",
   "--Pseudo (0=Sum,1=Product,2=Ratio,3=Position,4=PI,5=Multiplicty,6=User,7=Array)-",
   "------------------------Pseudo Setup ends here----------------------------------"
   };

if (Opt==0)
   {
   ReadHidden=FALSE;
   if ((Fp=fopen(RootSetupFName,"r"))==NULL) { strcpy(ErrMessg,"Could not find root setup file"); return 1; }
   }
else { ReadHidden=TRUE; if ((Fp=fopen(".lamps_root_set","r"))==NULL) return 0; }

//Persistent
if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nPersistent"); return 1; }
Persistent=atoi(&Line[41]); //g_print("Persistent=%d\n",Persistent);
if (!Persistent && ReadHidden)
   {
   fclose(Fp);
   //g_print("Reading of .lamps_root_set aborted as root setup is not persistent\n");
   return 0;      //The user wants to go back to LAMPS setup. Dont read the rest of the file
   }

//Tree Settings
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[0],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nHeading Tree Settings absent"); return 1; }
if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nTreeName absent"); return 1; }
ParseTextToStr(&Line[41],0,TreeName,&ToHere); //g_print("TreeName=%s\n",TreeName);
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[1],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nTree Settings end absent"); return 1; }

//Leaf List
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[2],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nHeading Leaf List absent"); return 1; }
if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Parameter.NPar missing"); return 1; }
Setup.Parameter.NPar=atoi(&Line[41]); //g_print("Setup.Parameter.NPar=%d\n",Setup.Parameter.NPar);
for (i=0;i<Setup.Parameter.NPar;++i)
   {
   if (fgets(Line,200,Fp)==NULL) { strcpy(ErrMessg,"Error reading setupfile\nmissing Leaf line"); return 1; }
   sscanf(Line,"%d %s %s %d %s %d %d %d",&j,LeafName[i],LeafType[i],&LType[i],Setup.Parameter.Name[i],&LeafMin[i],
          &LeafMax[i],&Setup.Parameter.Chan[i]);
   /*g_print("%d %s %s %d %s %d %d %d\n",j,LeafName[i],LeafType[i],LType[i],Setup.Parameter.Name[i],LeafMin[i],
              LeafMax[i],Setup.Parameter.Chan[i]);*/
   }
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[3],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nLeaf List end absent"); return 1; }

//Oned Setup
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[4],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nHeading Oned Setup absent"); return 1; }

if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Oned.N"); return 1; }
Setup.Oned.N=atoi(&Line[41]); //g_print("Setup.Oned.N=%d\n",Setup.Oned.N);
if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Oned.WSz"); return 1; }
Setup.Oned.WSz=atoi(&Line[41]); //g_print("Setup.Oned.WSz=%d\n",Setup.Oned.WSz);
for (i=0;i<Setup.Oned.N;++i)
    {
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Oned.Par[%d] etc",i+1); strcpy(ErrMessg,Str); return 1; }
    ParseTextToInt(&Line[41],0,3,Value,&ToHere);
    Setup.Oned.Par[i]=Value[0]; //g_print("Setup.Oned.Par[%d]=%d\n",i+1,Setup.Oned.Par[i]);
    Setup.Oned.NPar[i]=Value[1]; //g_print("Setup.Oned.NPar[%d]=%d\n",i+1,Setup.Oned.NPar[i]);
    Setup.Oned.Chan[i]=Value[2]; //g_print("Setup.Oned.Chan[%d]=%d\n",i+1,Setup.Oned.Chan[i]);
    if (Line[41+ToHere])
       { strcpy(Setup.Oned.Name[i],&Line[41+ToHere]); Setup.Oned.Name[i][strlen(Setup.Oned.Name[i])-1]='\0'; }
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Oned.Gate1[%d].NGates etc",i+1); strcpy(ErrMessg,Str); return 1; }
    ParseTextToInt(&Line[41],0,4,Value,&ToHere);
    Setup.Oned.Gate1[i].NGates=Value[0]; //g_print("Setup.Oned.Gate1[%d].NGates=%d\n",i+1,Setup.Oned.Gate1[i].NGates);
    Setup.Oned.Gate1[i].Cond=Value[1]; //g_print("Setup.Oned.Gate1[%d].Cond=%d\n",i+1,Setup.Oned.Gate1[i].Cond);
    Setup.Oned.Gate2[i].NGates=Value[2]; //g_print("Setup.Oned.Gate2[%d].NGates=%d\n",i+1,Setup.Oned.Gate2[i].NGates);
    Setup.Oned.Gate2[i].Cond=Value[3]; //g_print("Setup.Oned.Gate2[%d].Cond=%d\n",i+1,Setup.Oned.Gate2[i].Cond);
    for (j=0;j<Setup.Oned.Gate1[i].NGates;j++)
        {
        if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
           {
           sprintf(Str,"Error reading setupfile\nOned.Gate1[%d].Gate1d[%d] etc",i+1,j+1);
           strcpy(ErrMessg,Str); return 1;
           }
        ParseTextToInt(&Line[41],0,3,Value,&ToHere);
        if (Line[41+ToHere])
           { strcpy(Setup.Twod.Name[i],&Line[41+ToHere]); Setup.Twod.Name[i][strlen(Setup.Twod.Name[i])-1]='\0'; }
        Setup.Oned.Gate1[i].Gate1d[j].Para=Value[0];
        //g_print("Setup.Oned.Gate1[%d].Gate1d[%d].Para=%d\n",i+1,j+1,Setup.Oned.Gate1[i].Gate1d[j].Para);
        Setup.Oned.Gate1[i].Gate1d[j].Lo=Value[1];
        //g_print("Setup.Oned.Gate1[%d].Gate1d[%d].Lo=%d\n",i+1,j+1,Setup.Oned.Gate1[i].Gate1d[j].Lo);
        Setup.Oned.Gate1[i].Gate1d[j].Hi=Value[2];
        //g_print("Setup.Oned.Gate1[%d].Gate1d[%d].Hi=%d\n",i+1,j+1,Setup.Oned.Gate1[i].Gate1d[j].Hi);
        }

    for (j=0;j<Setup.Oned.Gate2[i].NGates;++j)
        {
        if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
           {
           sprintf(Str,"Error reading setupfile\nOned.Gate2[%d].Gate2d[%d] etc",i+1,j+1);
           strcpy(ErrMessg,Str); return 1;
           }
        ParseTextToStr(&Line[41],0,Str1,&ToHere); L=strlen(Str1);
        if ( (Str1[0] != '<') || (Str1[L-1] != '>') )
           {
           sprintf(Str,"Error reading setupfile\nOned.Gate2[%d].Gate2d[%d] missing <>",i+1,j+1);
           strcpy(ErrMessg,Str); return 1;
           }
        strncpy(Setup.Oned.Gate2[i].Gate2d[j],&Str1[1],LONG_TEXT_FIELD); Setup.Oned.Gate2[i].Gate2d[j][L-2]='\0';
        //g_print("Setup.Oned.Gate2[%d].Gate2d[%d]=[%s]\n",i+1,j+1,Setup.Oned.Gate2[i].Gate2d[j]);
        }
    }

if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[5],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nOned Setup end absent"); return 1; }

//Twod Setup
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[6],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nHeading Spectra Setup absent"); return 1; }

if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Twod.N"); return 1; }
Setup.Twod.N=atoi(&Line[41]); //g_print("Setup.Twod.N=%d\n",Setup.Twod.N);
if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Twod.WSz"); return 1; }
Setup.Twod.WSz=atoi(&Line[41]); //g_print("Setup.Twod.WSz=%d\n",Setup.Twod.WSz);
for (i=0;i<Setup.Twod.N;++i)
    {
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Twod.XPar[%d] etc",i+1); strcpy(ErrMessg,Str); return 1; }
    ParseTextToInt(&Line[41],0,6,Value,&ToHere);
    Setup.Twod.XPar[i]=Value[0]; //g_print("Setup.Twod.XPar[%d]=%d\n",i+1,Setup.Twod.XPar[i]);
    Setup.Twod.NXPar[i]=Value[1]; //g_print("Setup.Twod.NXPar[%d]=%d\n",i+1,Setup.Twod.NXPar[i]);
    Setup.Twod.YPar[i]=Value[2]; //g_print("Setup.Twod.YPar[%d]=%d\n",i+1,Setup.Twod.YPar[i]);
    Setup.Twod.NYPar[i]=Value[3]; //g_print("Setup.Twod.NYPar[%d]=%d\n",i+1,Setup.Twod.NYPar[i]);
    Setup.Twod.XChan[i]=Value[4]; //g_print("Setup.Twod.XChan[%d]=%d\n",i+1,Setup.Twod.XChan[i]);
    Setup.Twod.YChan[i]=Value[5]; //g_print("Setup.Twod.YChan[%d]=%d\n",i+1,Setup.Twod.YChan[i]);
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Twod.Gate1[%d].NGates etc",i+1); strcpy(ErrMessg,Str); return 1; }
    ParseTextToInt(&Line[41],0,4,Value,&ToHere);
    Setup.Twod.Gate1[i].NGates=Value[0]; //g_print("Setup.Twod.Gate1[%d].NGates=%d\n",i+1,Setup.Twod.Gate1[i].NGates);
    Setup.Twod.Gate1[i].Cond=Value[1]; //g_print("Setup.Twod.Gate1[%d].Cond=%d\n",i+1,Setup.Twod.Gate1[i].Cond);
    Setup.Twod.Gate2[i].NGates=Value[2]; //g_print("Setup.Twod.Gate2[%d].NGates=%d\n",i+1,Setup.Twod.Gate2[i].NGates);
    Setup.Twod.Gate2[i].Cond=Value[3]; //g_print("Setup.Twod.Gate2[%d].Cond=%d\n",i+1,Setup.Twod.Gate2[i].Cond);
    for (j=0;j<Setup.Twod.Gate1[i].NGates;++j)
        {
        if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
           {
           sprintf(Str,"Error reading setupfile\nTwod.Gate1[%d].Gate1d[%d] etc",i+1,j+1); strcpy(ErrMessg,Str);
           return 1;
           }
        ParseTextToInt(&Line[41],0,3,Value,&ToHere);
        Setup.Twod.Gate1[i].Gate1d[j].Para=Value[0];
        //g_print("Setup.Twod.Gate1[%d].Gate1d[%d].Para=%d\n",i+1,j+1,Setup.Twod.Gate1[i].Gate1d[j].Para);
        Setup.Twod.Gate1[i].Gate1d[j].Lo=Value[1];
        //g_print("Setup.Twod.Gate1[%d].Gate1d[%d].Lo=%d\n",i+1,j+1,Setup.Twod.Gate1[i].Gate1d[j].Lo);
        Setup.Twod.Gate1[i].Gate1d[j].Hi=Value[2];
        //g_print("Setup.Twod.Gate1[%d].Gate1d[%d].Hi=%d\n",i+1,j+1,Setup.Twod.Gate1[i].Gate1d[j].Hi);
        }
    for (j=0;j<Setup.Twod.Gate2[i].NGates;++j)
        {
        if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
           {
           sprintf(Str,"Error reading setupfile\nTwod.Gate2[%d].Gate2d[%d] etc",i+1,j+1); strcpy(ErrMessg,Str);
           return 1;
           }
        ParseTextToStr(&Line[41],0,Str1,&ToHere); L=strlen(Str1);
        if ( (Str1[0] != '<') || (Str1[L-1] != '>') )
           {
           sprintf(Str,"Error reading setupfile\nTwod.Gate2[%d].Gate2d[%d] missing <>",i+1,j+1);
           strcpy(ErrMessg,Str); return 1;
           }
        strncpy(Setup.Twod.Gate2[i].Gate2d[j],&Str1[1],LONG_TEXT_FIELD); Setup.Twod.Gate2[i].Gate2d[j][L-2]='\0';
        //g_print("Setup.Twod.Gate2[%d].Gate2d[%d]=[%s]\n",i+1,j+1,Setup.Twod.Gate2[i].Gate2d[j]);
        }
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
           { sprintf(Str,"Error reading setupfile\nSetup.Twod.CDdet.Enabled"); strcpy(ErrMessg,Str); return 1; }
    Setup.Twod.CDdet[i].Enabled=atoi(&Line[41]);
    }
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[7],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nTwod Setup end absent"); return 1; }

//Pseudo Setup
if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[8],75) )
    { strcpy(ErrMessg,"Error reading setupfile\nHeading Pseudo Setup absent"); return 1; }

if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
   { strcpy(ErrMessg,"Error reading setupfile\nSetup.Pseudo.N"); return 1; }
Setup.Pseudo.N=atoi(&Line[41]); //g_print("Setup.Pseudo.N=%d\n",Setup.Pseudo.N);

for (i=0;i<Setup.Pseudo.N;++i)
    {
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=') 
       { sprintf(Str,"Error reading setupfile\nSetup.Pseudo.P1[%d] etc",i+1); strcpy(ErrMessg,Str); return 1; }
    ParseTextToInt(&Line[41],0,4,Value,&ToHere);
    Setup.Pseudo.P1[i]=Value[0]; //g_print("Setup.Pseudo.P1[%d]=%d\n",i+1,Setup.Pseudo.P1[i]);
    Setup.Pseudo.P2[i]=Value[1]; //g_print("Setup.Pseudo.P2[%d]=%d\n",i+1,Setup.Pseudo.P2[i]);
    Setup.Pseudo.Size[i]=Value[2]; //g_print("Setup.Pseudo.Size[%d]=%d\n",i+1,Setup.Pseudo.Size[i]);
    Setup.Pseudo.Type[i]=Value[3]; //g_print("Setup.Pseudo.Type[%d]=%d\n",i+1,Setup.Pseudo.Type[i]);
    if (Line[41+ToHere])
      { strcpy(Setup.Pseudo.Name[i],&Line[41+ToHere]); Setup.Pseudo.Name[i][strlen(Setup.Pseudo.Name[i])-1]='\0'; }

    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Pseudo.K1[%d] etc",i+1); strcpy(ErrMessg,Str); return 1; }
    sscanf(&Line[41],"%g %g %g %g %g %g",&Setup.Pseudo.K1[i],&Setup.Pseudo.O1[i],&Setup.Pseudo.K2[i],
           &Setup.Pseudo.O2[i],&Setup.Pseudo.K3[i],&Setup.Pseudo.O3[i]);
    if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
       { sprintf(Str,"Error reading setupfile\nSetup.Pseudo.Power[%d] etc",i+1); strcpy(ErrMessg,Str); return 1; }
    sscanf(&Line[41],"%g %d %d",&Setup.Pseudo.Power[i],&Setup.Pseudo.L1[i],&Setup.Pseudo.L2[i]);
    if (Setup.Pseudo.Type[i] == Array)
       {
       if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
          { sprintf(Str,"Error reading setupfile\nSetup.Pseudo.ArrayN[%d]",i+1); strcpy(ErrMessg,Str); return 1; }
       sscanf(&Line[41],"%d",&Setup.Pseudo.ArrayN[i]);
       //g_print("Setup.Pseudo.ArrayN[%d]=%d\n",i+1,Setup.Pseudo.ArrayN[i]);
       for (j=0;j<Setup.Pseudo.ArrayN[i];++j)
           {
           if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
              {
              sprintf(Str,"Error reading setupfile\nSetup.Pseudo.ArrayPar etc[%d]",i+1); strcpy(ErrMessg,Str);
              return 1;
              }
           sscanf(&Line[41],"%d %d %d",&Setup.Pseudo.ArrayPar[j][i],&Setup.Pseudo.ArrayLLD[j][i],
                                       &Setup.Pseudo.ArrayULD[j][i]);
           /*g_print("Par,LLD,ULD[%d]=%d %d %d\n",i+1,Setup.Pseudo.ArrayPar[j][i],Setup.Pseudo.ArrayLLD[j][i],
                        Setup.Pseudo.ArrayULD[j][i]);*/
           if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
              {
              sprintf(Str,"Error reading setupfile\nSetup.Pseudo.ArrayOffset etc[%d]",i+1);
              strcpy(ErrMessg,Str); return 1;
              }
           sscanf(&Line[41],"%g %g %g",&Setup.Pseudo.ArrayOffset[j][i],&Setup.Pseudo.ArraySlope[j][i],
                  &Setup.Pseudo.ArrayQuad[j][i]);
           /*g_print("Offs,Slope,Quad[%d]=%g %g %g\n",i+1,Setup.Pseudo.ArrayOffset[j][i],
                       Setup.Pseudo.ArraySlope[j][i],Setup.Pseudo.ArrayQuad[j][i]);*/
           }
       }
    if (Setup.Pseudo.Type[i] == BGated)
       {
       if ( (fgets(Line,100,Fp)==NULL) || Line[40] != '=')
          {
          sprintf(Str,"Error reading setupfile\nBananaFile name for Pseudo %d",i+1);
          strcpy(ErrMessg,Str); return 1;
          }
       ParseTextToStr(&Line[41],0,Str1,&ToHere); L=strlen(Str1); 
       if ( (Str1[0] != '<') || (Str1[L-1] != '>') )
          { 
          sprintf(Str,"Error reading setupfile\nPs[%d] BGate file name missing <>",i+1); 
          strcpy(ErrMessg,Str); return 1; 
          }
        strncpy(PsBGated[i].Name,&Str1[1],LONG_TEXT_FIELD); PsBGated[i].Name[L-2]='\0';
        //g_print("PsBGated[%d].Name=[%s]\n",i+1,PsBGated[i].Name);
       }
    }

if ( (fgets(Line,100,Fp)==NULL) || strncmp(Line,Head[9],75) )
   { strcpy(ErrMessg,"Error reading setupfile\nPseudo Setup end absent"); return 1; }

fclose(Fp);
if (Opt==0) CheckRootSetup();
return 0;
}
//----------------------------------------------------------------------------------------------------------------------
void ReadRootSetupAs(GtkWidget *W,gpointer Unused)
{
char ErrMessg[MAX_FNAME_LENGTH+20];

if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH) 
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(RootSetupFName,"%s/%s",FileX->Path,FileX->TargetFile);
g_free(FileX);
if (OkReadRootSetup(ErrMessg,0)) { Attention(0,ErrMessg); return; }
}
//----------------------------------------------------------------------------------------------------------------------
void ReadRootSetup(GtkWidget *W,gpointer Unused)
{
if (ProgramState != Free) { Attention(0,"ReadRootSetup not allowed in current Program State"); return; }
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Read Root Setup",NULL,300,TopSpace+TopOfset,TRUE,SetupDir,".rot",FALSE,&ReadRootSetupAs,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void OkSaveRootSetup(gint Opt)                                  //Opt is normally 0. When Opt=1 we write .lamps_root_set
{
FILE *Fp;
gint i,j;

if (Opt==0) { if ((Fp=fopen(RootSetupFName,"w"))==NULL) { Attention(0,"Could not write setup file"); return; }}
else        { if ((Fp=fopen(".lamps_root_set","w"))==NULL) return; }

fprintf(Fp,"%-40s=%d\n","Persistent",Persistent);

fprintf(Fp,"--------------------------Tree Settings sarts here------------------------------\n");
fprintf(Fp,"%-40s=%s\n","Tree Name",TreeName);
fprintf(Fp,"---------------------------Tree Settings ends here------------------------------\n");

fprintf(Fp,"----------------------------Leaf List starts here-------------------------------\n");
fprintf(Fp,"%-40s=%d\n","No. of Parameters",Setup.Parameter.NPar);
for (i=0;i<Setup.Parameter.NPar;++i)
    fprintf(Fp,"%4d %s %s %d %s %d %d %d\n",i+1,LeafName[i],LeafType[i],LType[i],Setup.Parameter.Name[i],LeafMin[i],
            LeafMax[i],Setup.Parameter.Chan[i]);
fprintf(Fp,"---------------------------Leaf List Setup ends here----------------------------\n");

fprintf(Fp,"------------------------Oned Setup starts here----------------------------------\n");
fprintf(Fp,"%-40s=%d\n","No. of 1d Spectra",Setup.Oned.N);
fprintf(Fp,"%-40s=%d\n","Word Size",Setup.Oned.WSz);
for (i=0;i<Setup.Oned.N;i++)
    {
    fprintf(Fp,"Spec. No. %-4d Para,NPar,Size,Name      =%d %d %d %s\n",
            i+1,Setup.Oned.Par[i],Setup.Oned.NPar[i],Setup.Oned.Chan[i],Setup.Oned.Name[i]);
    fprintf(Fp,"NGates1,Cond,NGates2,Cond               =%d %d %d %d\n",
            Setup.Oned.Gate1[i].NGates,Setup.Oned.Gate1[i].Cond,Setup.Oned.Gate2[i].NGates,Setup.Oned.Gate2[i].Cond);
    for (j=0;j<Setup.Oned.Gate1[i].NGates;j++)
        fprintf(Fp,"Gate No. %-4d Para,Lo,Hi                =%d %d %d\n",j+1,Setup.Oned.Gate1[i].Gate1d[j].Para,
                Setup.Oned.Gate1[i].Gate1d[j].Lo,Setup.Oned.Gate1[i].Gate1d[j].Hi);
    for (j=0;j<Setup.Oned.Gate2[i].NGates;j++)
        fprintf(Fp,"Gate. No. %-4d BananaFile               =<%s>\n",j+1,Setup.Oned.Gate2[i].Gate2d[j]);
    }
fprintf(Fp,"------------------------Oned Setup ends here------------------------------------\n");

fprintf(Fp,"------------------------Twod Setup starts here----------------------------------\n");
fprintf(Fp,"%-40s=%d\n","No. of 2d Spectra",Setup.Twod.N);
fprintf(Fp,"%-40s=%d\n","Word Size",Setup.Twod.WSz);
for (i=0;i<Setup.Twod.N;i++)
    {
    fprintf(Fp,"Spec. No. %-4d XPr,Nx,YPr,Ny,XSz,YSz,Nm =%d %d %d %d %d %d %s\n",i+1,Setup.Twod.XPar[i],
            Setup.Twod.NXPar[i],Setup.Twod.YPar[i],Setup.Twod.NYPar[i],Setup.Twod.XChan[i],Setup.Twod.YChan[i],
            Setup.Twod.Name[i]);
    fprintf(Fp,"NGates1,Cond,NGates2,Cond               =%d %d %d %d\n",
            Setup.Twod.Gate1[i].NGates,Setup.Twod.Gate1[i].Cond,Setup.Twod.Gate2[i].NGates,Setup.Twod.Gate2[i].Cond);
    for (j=0;j<Setup.Twod.Gate1[i].NGates;j++)
        fprintf(Fp,"Gate No. %-4d Para,Lo,Hi                =%d %d %d\n",j+1,Setup.Twod.Gate1[i].Gate1d[j].Para,
                Setup.Twod.Gate1[i].Gate1d[j].Lo,Setup.Twod.Gate1[i].Gate1d[j].Hi);
    for (j=0;j<Setup.Twod.Gate2[i].NGates;j++)
        fprintf(Fp,"Gate. No. %-4d BananaFile               =<%s>\n",j+1,Setup.Twod.Gate2[i].Gate2d[j]);
    fprintf(Fp,"Spectrum Type (0=Normal, 1=CDdet)       =%d\n",Setup.Twod.CDdet[i].Enabled);
    if (Setup.Twod.CDdet[i].Enabled)
       for (j=0;j<8;++j) fprintf(Fp,"Parameter %2d                            =%d\n",j,Setup.Twod.CDdet[i].P[j]);
    }
fprintf(Fp,"------------------------Twod Setup ends here------------------------------------\n");

fprintf(Fp,"--Pseudo (0=Sum,1=Product,2=Ratio,3=Position,4=PI,5=Multiplicty,6=User,7=Array)-\n");
fprintf(Fp,"%-40s=%d\n","No. of Pseudo Parameters",Setup.Pseudo.N);
for (i=0;i<Setup.Pseudo.N;i++)
    {
    fprintf(Fp,"Pseudo No. %-4d P1,P2,Size,Type,Name    =%d %d %d %d %s\n",i+1,Setup.Pseudo.P1[i],Setup.Pseudo.P2[i],
            Setup.Pseudo.Size[i],Setup.Pseudo.Type[i],Setup.Pseudo.Name[i]);
    fprintf(Fp,"K1,O1,K2,O2,K3,O3                       =%g %g %g %g %g %g\n",Setup.Pseudo.K1[i],Setup.Pseudo.O1[i],
            Setup.Pseudo.K2[i],Setup.Pseudo.O2[i],Setup.Pseudo.K3[i],Setup.Pseudo.O3[i]);
    fprintf(Fp,"Power,L1,L2                             =%g %d %d\n",Setup.Pseudo.Power[i],
            Setup.Pseudo.L1[i],Setup.Pseudo.L2[i]);
    if (Setup.Pseudo.Type[i] == Array)
       {
       fprintf(Fp,"ArrayN                                  =%d\n",Setup.Pseudo.ArrayN[i]);
       for (j=0;j<Setup.Pseudo.ArrayN[i];++j)
           {
           fprintf(Fp,"Par,LLD,ULD                             =%d %d %d\n",
           Setup.Pseudo.ArrayPar[j][i],Setup.Pseudo.ArrayLLD[j][i],Setup.Pseudo.ArrayULD[j][i]);
           fprintf(Fp,"Offset,Slope,Quad                       =%g %g %g\n",
           Setup.Pseudo.ArrayOffset[j][i],Setup.Pseudo.ArraySlope[j][i],Setup.Pseudo.ArrayQuad[j][i]);
           }
       }
    if (Setup.Pseudo.Type[i] == BGated)
       fprintf(Fp,"BananaFile for BGated Pseudo            =<%s>\n",PsBGated[i].Name);
    }
fprintf(Fp,"------------------------Pseudo Setup ends here----------------------------------\n");

fclose(Fp);
}
//----------------------------------------------------------------------------------------------------------------------
void YesOverwriteRootSetup(GtkWidget *W,GtkWidget *Win)
{ gtk_widget_destroy(Win); OkSaveRootSetup(0); }
//----------------------------------------------------------------------------------------------------------------------
void SaveRootSetupAs(GtkWidget *W,gpointer Unused)
{
GtkWidget *Label,*But,*Win;
char Str[2500];

if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(RootSetupFName,"%s/%s",FileX->Path,FileX->TargetFile);
g_free(FileX);

if (access(RootSetupFName,0)==0) 
   {
   Win=gtk_dialog_new(); gtk_window_set_modal(GTK_WINDOW(Win),TRUE);
   g_signal_connect_swapped(Win,"destroy",G_CALLBACK(gtk_widget_destroy),Win);
   gtk_window_set_title(GTK_WINDOW(Win),"Overwrite?"); gtk_container_border_width(GTK_CONTAINER(Win),5);
   sprintf(Str,"Overwrite %s?",RootSetupFName);
   Label=gtk_label_new(Str); gtk_misc_set_padding(GTK_MISC(Label),10,10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->vbox),Label,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_YES);
   g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(YesOverwriteRootSetup),Win);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_NO);
   g_signal_connect_swapped(But,"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Win));
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   gtk_widget_show_all(Win);
   }
else OkSaveRootSetup(0);
}
//----------------------------------------------------------------------------------------------------------------------
void SaveRootSetup(GtkWidget *W,gpointer Unused)
{
if (ProgramState != Free) { Attention(0,"SaveRootSetup not allowed in current Program State"); return; }
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Save Root Setup",NULL,300,TopSpace+TopOfset,FALSE,SetupDir,".rot",FALSE,&SaveRootSetupAs,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void CheckRoot(void)
{
gint i;

for (i=0;i<Setup.Parameter.NPar;++i)                                      
   {
   if (strlen(Setup.Parameter.Name[i])==0) strcpy(Setup.Parameter.Name[i],LeafName[i]);       //Replace blank para names
   LeafMax[i]=MAX(LeafMax[i],LeafMin[i]+100);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void CheckRootSetup(void)
{
CheckRoot();                                                                            //Sanity check of ROOT leaf data
CheckPseudos();                                                                       //Clamp parameters in pseudo setup
CalculateBitShifts();                                           //The bit shifts required for building 1d and 2d spectra
CheckOned();
CheckTwod();
AllocateMemory();                                                                //Allocate memory for 1d and 2d spectra
AllocateScreenWins();                                                        //Assign spectra to windows for each screen
ParameterList(NULL,NULL);
OkSaveRootSetup(1);                     //Root setup file saved to .lamps_root_set so that lamps can read it on re-start
}
//----------------------------------------------------------------------------------------------------------------------
void RootSetupClosed(GtkWidget *W,GtkWidget *Win)
{
gint i;

if (ProgramState !=DoingSetup) { Attention(0,"Invalid operation"); return; }

//Go through the leaf list to find where it ends with a blank leaf name
for (i=0;i<MAX_PAR;++i) if (strlen(LeafName[i])==0) break;
Setup.Parameter.NPar=i;
if (Setup.Parameter.NPar==0)  //Insert one dummy leaf to avoid errors
   {
   Setup.Parameter.NPar=1;
   strcpy(LeafName[0],"No Leaf?"); strcpy(Setup.Parameter.Name[0],"No Leaf?");
   }
gtk_widget_destroy(GTK_WIDGET(Win));
g_free(WPers);
g_free(WTreeN); g_free(WNum); g_free(WLeafN); g_free(WLType); g_free(WParaN);
g_free(WLeafMin); g_free(WLeafMax); g_free(WResl); g_free(WKeep);
}
//----------------------------------------------------------------------------------------------------------------------
void RootSetupDestroyed(GtkWidget *W,gpointer Unused)
{
if (ProgramState !=DoingSetup) { Attention(0,"Invalid operation!"); return; }
CheckRootSetup(); ProgramState=Free;
}
//----------------------------------------------------------------------------------------------------------------------
void UseRootFileInfo()
{
gint i,R;

R=RootFileInfo(RFName);
if (R==1) { Attention(0,"ERROR: This is not a root file!"); return; }
gtk_entry_set_text(GTK_ENTRY(WTreeN[0]),TreeName);
if (R==2)
   {
   if (ActiveTree==0) Attention(0,"ERROR: This root file does not contain any tree");
   else { Attention(0,"There are no more trees!"); --ActiveTree; }
   return;
   }
if (R==3) { Attention(0,"ERROR: This tree does not have leaves!"); return; }
gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(WPers[0])->entry),"ROOT Setup");
gtk_button_set_label(GTK_BUTTON(BrowseBut),basename(RFName));

for (i=0;i<MAX_PAR;++i)
   {
   strcpy(Setup.Parameter.Name[i],LeafName[i]);
   LeafMin[i]=0; LeafMax[i]=4095;
   Setup.Parameter.Chan[i]=4096;
   }
ChangePage(NULL,0);
}
//----------------------------------------------------------------------------------------------------------------------
void GetRootFName(GtkWidget *W,gpointer Unused)
{
if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(RFName,"%s/%s",FileX->Path,FileX->TargetFile);
g_free(FileX);
ActiveTree=0; UseRootFileInfo();
}
//----------------------------------------------------------------------------------------------------------------------
void RootBrowse(GtkButton *But,GtkWidget *Win)
{
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Select file",Win,90,120,TRUE,ListFDir,".root",TRUE,&GetRootFName,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void NextTreeFun(GtkWidget *W,gpointer Data) 
{
if (strlen(RFName)==0) { Attention(0,"Please Browse a root file first!"); return; }
++ActiveTree; UseRootFileInfo();
}
//----------------------------------------------------------------------------------------------------------------------
void PrevTreeFun(GtkWidget *W,gpointer Data)
{
if (strlen(RFName)==0) { Attention(0,"Please Browse a root file first!"); return; }
if (ActiveTree>0) --ActiveTree;
UseRootFileInfo();
}
//----------------------------------------------------------------------------------------------------------------------
void EditRootSetup(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*VBox,*VBox1,*VBox2,*VBox3,*HBox,*HBox1,*Label,*ScrollW,*Table,*TitlesBut,*But,*Frame,*Spin,
          *Tog,*NextTree,*PrevTree,*VBoxA;
GtkAdjustment *Adj;
static GdkColor RedBg     = {0,0x0000,0x0000,0x0000};
static GdkColor RedFg     = {0,0xFFFF,0x0000,0x0000};
static GdkColor BlueBg    = {0,0x0000,0x0000,0x0000};
static GdkColor BlueFg    = {0,0x0000,0x0000,0x9999};
static GdkColor TitlesBg  = {0,0x0000,0x0000,0x8888};
static GdkColor TitlesFg  = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor WinBg     = {0,0xDC00,0xDC00,0xFFFF};
static GdkColor FrameBg   = {0,0x7777,0x7777,0x7777};
static GdkColor FrameFg   = {0,0xFFFF,0x0000,0x0000};
static gchar *Titles[8]= {"Para","Leaf Name","Type","Para Name","MinVal",
   "MaxVal","LampsResl","Keep?"};
gint i,ColWidth[8]={50,150,130,180,80,80,90,80},PIndex,k;
GtkStyle *RedStyle,*BlueStyle,*TitlesStyle,*FrameStyle;
gchar Str[255];
GList *GList,*GList2;

if (ProgramState != Free) { Attention(0,"Edit Root Setup is not allowed in the current Program State"); return; }
CloseAllSpecWindows(NULL,NULL);
ProgramState=DoingSetup; LeafLock=FALSE; strcpy(RFName,"");

//Allocate memory for widget arrays
WPers=g_new(GtkWidget *,1); WTreeN=g_new(GtkWidget *,1);
WNum=g_new(GtkWidget *,PAGE_SIZE); WLeafN=g_new(GtkWidget *,PAGE_SIZE); WLType=g_new(GtkWidget *,PAGE_SIZE);
WParaN=g_new(GtkWidget *,PAGE_SIZE); WLeafMin=g_new(GtkWidget *,PAGE_SIZE); WLeafMax=g_new(GtkWidget *,PAGE_SIZE);
WResl=g_new(GtkWidget *,PAGE_SIZE); WKeep=g_new(GtkWidget *,PAGE_SIZE);

//Set styles
RedStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { RedStyle->fg[i]=RedStyle->text[i]=RedFg; RedStyle->bg[i]=RedBg; }
BlueStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=BlueFg; BlueStyle->bg[i]=BlueBg; }
TitlesStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { TitlesStyle->fg[i]=TitlesStyle->text[i]=TitlesFg; TitlesStyle->bg[i]=TitlesBg; }
FrameStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { FrameStyle->fg[i]=FrameStyle->text[i]=FrameFg; FrameStyle->bg[i]=FrameBg; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_widget_modify_bg(Win,GTK_STATE_NORMAL,&WinBg);
gtk_window_set_title(GTK_WINDOW(Win),"Edit Root Setup");
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(RootSetupDestroyed),NULL);
gtk_container_set_border_width(GTK_CONTAINER(Win),10);
VBox1=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox1);

HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
VBox2=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox1),VBox2,FALSE,FALSE,2);
VBox3=gtk_vbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(HBox1),VBox3,FALSE,FALSE,2);

//VBox2 (left part) starts here
HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox2),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Required to analyse ROOT files.\nNot required for Acqisition");
gtk_box_pack_start(GTK_BOX(VBox2),Label,FALSE,FALSE,0); SetStyleRecursively(Label,RedStyle);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox2),HBox,FALSE,FALSE,0);
VBoxA=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBoxA,FALSE,FALSE,0);
Label=gtk_label_new("Make persistent"); gtk_box_pack_start(GTK_BOX(VBoxA),Label,FALSE,TRUE,0);
GList2=NULL; GList2=g_list_append(GList2,"ROOT Setup"); 
GList2=g_list_append(GList2,"LAMPS Setup");
WPers[0]=gtk_combo_new();
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(WPers[0])->entry),FALSE);
gtk_widget_set_size_request(GTK_WIDGET(WPers[0]),145,-1);
gtk_combo_set_popdown_strings(GTK_COMBO(WPers[0]),GList2);
if (Persistent) gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(WPers[0])->entry),"ROOT Setup");
else  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(WPers[0])->entry),"LAMPS Setup");
g_signal_connect(GTK_OBJECT(GTK_COMBO(WPers[0])->entry),"changed",G_CALLBACK(PersistentChanged),NULL);
gtk_box_pack_start(GTK_BOX(VBoxA),WPers[0],FALSE,TRUE,0);
HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox2),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Make ROOT Setup persistent\nunless going back to LAMPS data\n");
SetStyleRecursively(Label,BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,TRUE,10);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox2),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Tree\nName"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
WTreeN[0]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
gtk_entry_set_text(GTK_ENTRY(WTreeN[0]),TreeName);
gtk_box_pack_start(GTK_BOX(HBox),WTreeN[0],FALSE,FALSE,5);
g_signal_connect(GTK_OBJECT(WTreeN[0]),"changed",G_CALLBACK(TreeNameChanged),NULL);

Frame=gtk_frame_new("SPECTRA SETTINGS"); gtk_frame_set_label_align(GTK_FRAME(Frame),0.5,0.5);
SetStyleRecursively(Frame,FrameStyle);
gtk_box_pack_start(GTK_BOX(VBox2),Frame,FALSE,FALSE,0);
VBox=gtk_vbox_new(FALSE,10); gtk_container_add(GTK_CONTAINER(Frame),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),4);
HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
VBoxA=gtk_vbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(HBox),VBoxA,FALSE,FALSE,0);
Label=gtk_label_new("No of 1d Spec."); gtk_box_pack_start(GTK_BOX(VBoxA),Label,FALSE,FALSE,5);
Adj=(GtkAdjustment *)gtk_adjustment_new(Setup.Oned.N,0,MAX_1D,1,5,0);
Spin=gtk_spin_button_new(Adj,0.5,0); gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_box_pack_start(GTK_BOX(VBoxA),Spin,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(Adj),"value_changed",G_CALLBACK(N1Changed),(gpointer)Spin);
if (Setup.Oned.WSz==1) strcpy(Str,"Single\nWord"); else strcpy(Str,"Double\nWord");
Tog=gtk_toggle_button_new_with_label(Str); gtk_box_pack_start(GTK_BOX(HBox),Tog,FALSE,FALSE,0);
gtk_signal_connect(GTK_OBJECT(Tog),"toggled",G_CALLBACK(SpecWSz1),NULL);
But=gtk_button_new_with_label("Define"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SetOned),NULL);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
VBoxA=gtk_vbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(HBox),VBoxA,FALSE,FALSE,0);
Label=gtk_label_new("No of 2d Spec."); gtk_box_pack_start(GTK_BOX(VBoxA),Label,FALSE,FALSE,5);
Adj=(GtkAdjustment *)gtk_adjustment_new(Setup.Twod.N,0,MAX_2D,1,5,0);
Spin=gtk_spin_button_new(Adj,0.5,0); gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_box_pack_start(GTK_BOX(VBoxA),Spin,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(Adj),"value_changed",G_CALLBACK(N2Changed),(gpointer)Spin);
if (Setup.Twod.WSz==1) strcpy(Str,"Single\nWord"); else strcpy(Str,"Double\nWord");
Tog=gtk_toggle_button_new_with_label(Str); gtk_box_pack_start(GTK_BOX(HBox),Tog,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(Tog),"toggled",G_CALLBACK(SpecWSz2),NULL);
But=gtk_button_new_with_label("Define"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SetTwod),NULL);

Frame=gtk_frame_new("PSEUDO PARA SETTINGS"); gtk_frame_set_label_align(GTK_FRAME(Frame),0.5,0.5);
SetStyleRecursively(Frame,FrameStyle);
gtk_box_pack_start(GTK_BOX(VBox2),Frame,FALSE,FALSE,0);
VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Frame),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),4);
HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
VBoxA=gtk_vbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(HBox),VBoxA,FALSE,FALSE,0);
Label=gtk_label_new("No of Pseudos"); gtk_box_pack_start(GTK_BOX(VBoxA),Label,FALSE,FALSE,10);
Adj=(GtkAdjustment *)gtk_adjustment_new(Setup.Pseudo.N,0,MAX_PSEUDO,1,5,0);
Spin=gtk_spin_button_new(Adj,0.5,0); gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(Spin),TRUE);
gtk_box_pack_start(GTK_BOX(VBoxA),Spin,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(Adj),"value_changed",G_CALLBACK(NPChanged),(gpointer)Spin);
But=gtk_button_new_with_label("Define"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SetPseudo),NULL);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_end(GTK_BOX(VBox2),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("Root Setup Done"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,10);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(RootSetupClosed),Win);
//VBox2 (left part) ends here

//VBox3 (right part) starts here
Frame=gtk_frame_new("LEAF LIST"); gtk_frame_set_label_align(GTK_FRAME(Frame),0.5,0.5);
SetStyleRecursively(Frame,FrameStyle);
gtk_box_pack_start(GTK_BOX(VBox3),Frame,FALSE,FALSE,0);
VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Frame),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),10);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Browse root file"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,TRUE,4);
BrowseBut=gtk_button_new_with_label("Browse"); gtk_box_pack_start(GTK_BOX(HBox),BrowseBut,FALSE,TRUE,4);
NextTree=gtk_button_new_with_label("Next Tree"); gtk_box_pack_start(GTK_BOX(HBox),NextTree,FALSE,TRUE,4);
PrevTree=gtk_button_new_with_label("Prev Tree"); gtk_box_pack_start(GTK_BOX(HBox),PrevTree,FALSE,TRUE,4);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Keep only required leaves. Blank Leaf terminates list");
gtk_misc_set_alignment(GTK_MISC(Label),0.0f,0.0f);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0); SetStyleRecursively(Label,BlueStyle);
ScrollW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollW),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
gtk_widget_set_size_request(GTK_WIDGET(ScrollW),860,30);
gtk_container_add(GTK_CONTAINER(VBox),ScrollW);

Table=gtk_table_new(1,8,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollW),Table);
for (i=0;i<8;++i)
    {
    TitlesBut=gtk_button_new_with_label(Titles[i]); SetStyleRecursively(TitlesBut,TitlesStyle);
    gtk_widget_set_size_request(GTK_WIDGET(TitlesBut),ColWidth[i],-1);
    gtk_table_attach(GTK_TABLE(Table),TitlesBut,i,i+1,0,1,GTK_FILL,GTK_SHRINK,0,0);
    }

ScrollW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollW),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
gtk_widget_set_size_request(GTK_WIDGET(ScrollW),860,410);
gtk_container_add(GTK_CONTAINER(VBox),ScrollW);

Table=gtk_table_new(MAX_PAR,8,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollW),Table);
GList=NULL; GList=g_list_append(GList,"1 K"); GList=g_list_append(GList,"2 K");
GList=g_list_append(GList,"4 K"); GList=g_list_append(GList,"8 K"); GList=g_list_append(GList,"16 K");
GList=g_list_append(GList,"32 K"); GList=g_list_append(GList,"64 K");

LastPage=MAX_PAR/PAGE_SIZE-1; Page=CLAMP(Page,0,LastPage);
for (i=0;i<PAGE_SIZE;++i)
    {
    PIndex=PAGE_SIZE*Page+i;
    if (PIndex>=MAX_PAR) break;
    WNum[i]=gtk_entry_new_with_max_length(4);
    gtk_entry_set_editable(GTK_ENTRY(WNum[i]),FALSE);
    sprintf(Str,"%3d",PIndex+1);
    gtk_entry_set_text(GTK_ENTRY(WNum[i]),Str);
    gtk_widget_set_size_request(GTK_WIDGET(WNum[i]),ColWidth[0],-1);
    gtk_table_attach(GTK_TABLE(Table),WNum[i],0,1,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WLeafN[i]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
    gtk_entry_set_text(GTK_ENTRY(WLeafN[i]),LeafName[PIndex]);
    g_signal_connect(GTK_OBJECT(WLeafN[i]),"changed",G_CALLBACK(LeafNameChanged),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WLeafN[i]),ColWidth[1],-1);
    gtk_table_attach(GTK_TABLE(Table),WLeafN[i],1,2,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WLType[i]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
    gtk_entry_set_editable(GTK_ENTRY(WLType[i]),FALSE);
    gtk_entry_set_text(GTK_ENTRY(WLType[i]),LeafType[PIndex]);
    gtk_widget_set_size_request(GTK_WIDGET(WLType[i]),ColWidth[2],-1);
    gtk_table_attach(GTK_TABLE(Table),WLType[i],2,3,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WParaN[i]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
    gtk_entry_set_text(GTK_ENTRY(WParaN[i]),Setup.Parameter.Name[PIndex]);
    g_signal_connect(GTK_OBJECT(WParaN[i]),"changed",G_CALLBACK(ParNameChanged),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WParaN[i]),ColWidth[3],-1);
    gtk_table_attach(GTK_TABLE(Table),WParaN[i],3,4,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WLeafMin[i]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
    sprintf(Str,"%d",LeafMin[PIndex]); gtk_entry_set_text(GTK_ENTRY(WLeafMin[i]),Str);
    g_signal_connect(GTK_OBJECT(WLeafMin[i]),"changed",G_CALLBACK(LeafMinChanged),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WLeafMin[i]),ColWidth[4],-1);
    gtk_table_attach(GTK_TABLE(Table),WLeafMin[i],4,5,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WLeafMax[i]=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
    sprintf(Str,"%d",LeafMax[PIndex]); gtk_entry_set_text(GTK_ENTRY(WLeafMax[i]),Str);
    g_signal_connect(GTK_OBJECT(WLeafMax[i]),"changed",G_CALLBACK(LeafMaxChanged),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WLeafMax[i]),ColWidth[5],-1);
    gtk_table_attach(GTK_TABLE(Table),WLeafMax[i],5,6,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WResl[i]=gtk_combo_new();
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(WResl[i])->entry),FALSE);
    gtk_combo_set_popdown_strings(GTK_COMBO(WResl[i]),GList);
    k=Setup.Parameter.Chan[i]/1024; sprintf(Str,"%d K",k);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(WResl[i])->entry),Str);
    g_signal_connect(GTK_OBJECT(GTK_COMBO(WResl[i])->entry),"changed",G_CALLBACK(ReslChanged),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WResl[i]),ColWidth[6],-1);
    gtk_table_attach(GTK_TABLE(Table),WResl[i],6,7,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

    WKeep[i]=gtk_check_button_new_with_label("Keep");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WKeep[i]),TRUE);
    g_signal_connect(WKeep[i],"toggled",G_CALLBACK(KeepLeaf),GINT_TO_POINTER(i));
    gtk_widget_set_size_request(GTK_WIDGET(WKeep[i]),ColWidth[7],-1);
    gtk_table_attach(GTK_TABLE(Table),WKeep[i],7,8,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    }
HBox=gtk_hbox_new(FALSE,30); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,6);
But=gtk_button_new_with_label("Prev Page"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ChangePage),GINT_TO_POINTER(-1));
But=gtk_button_new_with_label("Del unwanted leaves"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(DelUnwantedLeaves),GINT_TO_POINTER(-1));
But=gtk_button_new_with_label("Next Page"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ChangePage),GINT_TO_POINTER(1));

g_signal_connect(GTK_OBJECT(BrowseBut),"clicked",G_CALLBACK(RootBrowse),Win);
g_signal_connect(GTK_OBJECT(NextTree),"clicked",G_CALLBACK(NextTreeFun),Win);
g_signal_connect(GTK_OBJECT(PrevTree),"clicked",G_CALLBACK(PrevTreeFun),Win);
//VBox3 (right part) ends here

gtk_widget_show_all(Win); gtk_window_move(GTK_WINDOW(Win),0,60);
gtk_style_unref(RedStyle); gtk_style_unref(BlueStyle); gtk_style_unref(TitlesStyle);
gtk_style_unref(FrameStyle); g_list_free(GList); g_list_free(GList2);
}
//----------------------------------------------------------------------------------------------------------------------


