#include <TFile.h>
#include <TTree.h>
#include <TLeafElement.h>
#include <stdio.h>
#include <string.h>
#include <iostream>
#define MAX_PAR        1000                                                                 //Must be same as in lamps.h
#define MAX_TEXT_FIELD 99                                                                   //Must be same as in lamps.h
#define EVTS_PER_BUF   1000                                          //Adhoc value, ideally should match the ROOT basket

//C style function declarations
extern "C" void OpenRootFile(char *,int,char [][MAX_TEXT_FIELD],char *);
extern "C" void OpenRootFileDouble(char *,int,char [][MAX_TEXT_FIELD],char *);
extern "C" void WriteRootBlock(unsigned short *,int,int);
extern "C" void WriteRootBlockDouble(unsigned short *,int,int);
extern "C" void CloseRootFile(void);
extern "C" int RootFileInfo(char *);
extern "C" int OpenRootFileForAnalysis(char *,int);
extern "C" int ReadRootBlock(int,int,int *,long *,float *);
extern "C" void CloseRootFileForAnalysis(void);
extern "C" void ProcessEvent(unsigned short *,int);                                              //Code is in readfile.c
extern "C" int ReadRootBlockForReWrite(int,int,int *,long *,int *,float *,int,int *,unsigned short *);
//Globals in this file
TFile *Tf;
TTree *Tree;
unsigned short P[MAX_PAR];
double Pd[MAX_PAR];
int BufCount;
//External globals
extern char TreeName[MAX_TEXT_FIELD],LeafName[MAX_PAR][MAX_TEXT_FIELD],LeafType[MAX_PAR][MAX_TEXT_FIELD];
extern int LType[MAX_PAR],LeafMin[MAX_PAR],LeafMax[MAX_PAR],ActiveTree;
extern long BytesWritten;
//----------------------------------------------------------------------------------------------------------------------
void OpenRootFile(char *FName,int NPar,char ParName[][MAX_TEXT_FIELD],char *TreeNam)
{
int i;
char LeafName[MAX_TEXT_FIELD+2];
Tf=new TFile(Form(FName,basename(FName)),"RECREATE");
if (strlen(TreeNam)==0) Tree=new TTree("LampsTree","LampsTree");
else Tree=new TTree(TreeNam,TreeNam);

for (i=0;i<NPar;++i)
   {
   sprintf(LeafName,"%s/s",ParName[i]);
   Tree->Branch(ParName[i],&P[i],LeafName);
   }
BufCount=0;
}
//----------------------------------------------------------------------------------------------------------------------
void OpenRootFileDouble(char *FName,int NPar,char ParName[][MAX_TEXT_FIELD],char TreeNam[])
{
int i;
char LeafName[MAX_TEXT_FIELD+2];
Tf=new TFile(Form(FName,basename(FName)),"RECREATE");
if (strlen(TreeNam)==0) Tree=new TTree("LampsTree","LampsTree");
else Tree=new TTree(TreeNam,TreeNam);

for (i=0;i<NPar;++i)
   {
   sprintf(LeafName,"%s/D",ParName[i]);
   Tree->Branch(ParName[i],&Pd[i],LeafName);
   }
BufCount=0;
}
//----------------------------------------------------------------------------------------------------------------------
void WriteRootBlock(unsigned short *AcqBuf,int NEvt,int NPar)
{
int i,j,Ptr;

for (i=0,Ptr=0;i<NEvt;++i,Ptr+=NPar)
   {
   for(j=0;j<NPar;++j) P[j]=AcqBuf[Ptr+j];
   Tree->Fill();
   }
++BufCount;
//Tree->AutoSave(); Tf->Flush();                       //We dont need to commit to disk at every buffer for offline work
BytesWritten=(long)Tf->GetSize();                        //Due to ROOT internals this may not increase at every BufCount
}
//----------------------------------------------------------------------------------------------------------------------
void WriteRootBlockDouble(unsigned short *AcqBuf,int NEvt,int NPar)
{
int i,j,Ptr;

for (i=0,Ptr=0;i<NEvt;++i,Ptr+=NPar)
   {
   for(j=0;j<NPar;++j) Pd[j]=(double)AcqBuf[Ptr+j];
   Tree->Fill();
   }
++BufCount;
BytesWritten=(long)Tf->GetSize();                        //Due to ROOT internals this may not increase at every BufCount
}
//----------------------------------------------------------------------------------------------------------------------
void CloseRootFile(void)
{
Tree->Write("",TObject::kOverwrite);
Tf->Close();
}
//----------------------------------------------------------------------------------------------------------------------
int RootFileInfo(char *FName)                        //Return value: 0 normal, 1 not a root file, 2 no tree, 3 no leaves
{
static char Accept[29][40] = 
   {
   "Char_t","char",                                                                        //0,1      char
   "UChar_t","Byte_t","unsigned char",                                                     //2,3,4    unsigned char
   "Short_t","short","short int",                                                          //5,6,7    short int
   "UShort_t","unsigned short",                                                            //8,9      unsigned short
   "Int_t","int",                                                                          //10,11    int
   "UInt_t","unsigned int","unsigned",                                                     //12,13,14 unsigned
   "Long_t","long",                                                                        //15,16    long
   "ULong_t","unsigned long",                                                              //17,18    unsigned long
   "Long64_t","long long",                                                                 //19,20    long long
   "ULong64_t","unsigned long long",                                                       //21,22    unsigned long long
   "Float_t","Float16_t","float",                                                          //23,24,25 float
   "Double_t","Double32_t","double"                                                        //26,27,28 double           
   };
int i,j,k,NAccept,NoTree,NoLeaves,TreeNo;
TFile *F=new TFile(FName);
TObject *Obj;
TTree *T;

if (!strstr(basename(FName),".root")) return 1;                                              //File name must have .root
strcpy(TreeName,"");                                                                                //Initialize strings
for (i=0;i<MAX_PAR;++i) { strcpy(LeafName[i],""); strcpy(LeafType[i],""); }                         //Initialize strings

//Get TreeName for the tree number flagged as ActiveTree
NoTree=1; TreeNo=0; strcpy(TreeName,"No tree found!");
for (i=0;i<F->GetListOfKeys()->GetEntries();++i)
   {
   Obj=F->GetListOfKeys()->At(i);
   if (!Obj) break;
   else
      { 
      T=(TTree *)F->Get(Obj->GetName());
      if (T->InheritsFrom(TTree::Class()))
         {
         if (TreeNo==ActiveTree) { strcpy(TreeName,T->GetName()); NoTree=0; break; }
         ++TreeNo;
         }
      }
   }
if (NoTree==1) return 2;

//Get leaf names (branches are irrelevant). Keep only those of acceptable types (arrays are not acceptable)
NoLeaves=1;
NAccept=sizeof(Accept)/sizeof(Accept[0]);
for (i=0,j=0;i<T->GetListOfLeaves()->GetEntriesFast();++i)
   {
   Obj=T->GetListOfLeaves()->At(i);
   if (!Obj) break;
   for (k=0;k<NAccept;++k)
      {
      if (!strcmp(T->GetLeaf(Obj->GetName())->GetTypeName(),Accept[k]))
         {
         strncpy(LeafName[j],Obj->GetName(),MAX_TEXT_FIELD); LeafName[j][MAX_TEXT_FIELD-1]='\0';       //Careful strcpy!
         strncpy(LeafType[j],Accept[k],MAX_TEXT_FIELD); LeafType[j][MAX_TEXT_FIELD-1]='\0';            //Careful strcpy!
         switch (k)
            {
            case 0: case 1:             LType[j]= 0; break;                                //0,1      char
            case 2: case 3: case 4:     LType[j]= 1; break;                                //2,3,4    unsigned char
            case 5: case 6: case 7:     LType[j]= 2; break;                                //5,6,7    short
            case 8: case 9:             LType[j]= 3; break;                                //8,9      unsigned short
            case 10: case 11:           LType[j]= 4; break;                                //10,11    int
            case 12: case 13: case 14:  LType[j]= 5; break;                                //12,13,14 unsigned int
            case 15: case 16:           LType[j]= 6; break;                                //15,16    long
            case 17: case 18:           LType[j]= 7; break;                                //17,18    unsigned long 
            case 19: case 20:           LType[j]= 8; break;                                //19,20    long long
            case 21: case 22:           LType[j]= 9; break;                                //21,22    unsigned long long
            case 23: case 24: case 25:  LType[j]=10; break;                                //23,24,25 float
            case 26: case 27: case 28:  LType[j]=11;                                       //26,27,28 double
            }
         ++j; NoLeaves=0; break;
         }
      }
   }
if (NoLeaves==1) return 3;

return 0;
}
//----------------------------------------------------------------------------------------------------------------------
int OpenRootFileForAnalysis(char *FName,int NPar)               //Return 1 on success, 0:Cant open or wrong leaf name(s)
{
TLeaf *Leaf;
int i;

Tf=new TFile(FName); if (!(Tf->IsOpen())) return 0;
Tree=(TTree *)Tf->Get(TreeName); if (!Tree) return 0;
for (i=0;i<NPar;++i)
   {
   Leaf=Tree->GetLeaf(LeafName[i]);
   if (!Leaf) return 0;
   }
return 1;
}
//----------------------------------------------------------------------------------------------------------------------
unsigned short Transform(double Q,int Min,int Max,int Chan)
{
unsigned short X;

X=(unsigned short)((Q-Min)*Chan/(Max-Min));
if (X<0) return 0;
if (X>Chan-1) return Chan-1;
return X;
}
//----------------------------------------------------------------------------------------------------------------------
int ReadRootBlock(int BufNo,int NPar,int *Chan,long *EvtsRead,float *FracRead)
//Reads a block of ROOT data. Return 0 normally, 1 if no more data
{
Long64_t iEvt,NEntries,iStart,iEnd,Delta;
int i;
unsigned short P[MAX_PAR]; 
char Qc[MAX_PAR]; unsigned char Quc[MAX_PAR]; short Qs[MAX_PAR]; unsigned short Qus[MAX_PAR];
int Qi[MAX_PAR]; unsigned int Qui[MAX_PAR]; long Ql[MAX_PAR]; unsigned long Qul[MAX_PAR];
long long Qll[MAX_PAR]; unsigned long long Qull[MAX_PAR]; float Qf[MAX_PAR]; double Qd[MAX_PAR];

NEntries=Tree->GetEntriesFast();
iStart=EVTS_PER_BUF*BufNo; if (iStart>NEntries) return 1;
iEnd=iStart+EVTS_PER_BUF; if (iEnd>NEntries) iEnd=NEntries;
for (i=0;i<NPar;++i)                                                  //Declare location in memory where entries will go
   {
   switch (LType[i])
      {
      case  0: Tree->SetBranchAddress(LeafName[i],&Qc[i]); break;                                                 //char
      case  1: Tree->SetBranchAddress(LeafName[i],&Quc[i]); break;                                       //unsigned char
      case  2: Tree->SetBranchAddress(LeafName[i],&Qs[i]); break;                                                //short
      case  3: Tree->SetBranchAddress(LeafName[i],&Qus[i]); break;                                      //unsigned short
      case  4: Tree->SetBranchAddress(LeafName[i],&Qi[i]); break;                                                  //int
      case  5: Tree->SetBranchAddress(LeafName[i],&Qui[i]); break;                                        //unsigned int
      case  6: Tree->SetBranchAddress(LeafName[i],&Ql[i]); break;                                                 //long
      case  7: Tree->SetBranchAddress(LeafName[i],&Qul[i]); break;                                       //unsigned long
      case  8: Tree->SetBranchAddress(LeafName[i],&Qll[i]); break;                                           //long long
      case  9: Tree->SetBranchAddress(LeafName[i],&Qull[i]); break;                                 //unsigned long long
      case 10: Tree->SetBranchAddress(LeafName[i],&Qf[i]); break;                                                //float
      case 11: Tree->SetBranchAddress(LeafName[i],&Qd[i]);                                                      //double
      }
   }
for (iEvt=iStart;iEvt<iEnd;++iEvt)                                                                    //Loop over events
   {
   Tree->GetEntry(iEvt);                          //Now all values of Q of various types have been stored for this event 
   for (i=0;i<NPar;++i)
      {
      switch (LType[i])
         { 
         case  0: P[i]=Transform(Qc[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                                   //char
         case  1: P[i]=Transform(Quc[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                          //unsigned char
         case  2: P[i]=Transform(Qs[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                                  //short
         case  3: P[i]=Transform(Qus[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                                    //int
         case  4: P[i]=Transform(Qi[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                           //unsigned int
         case  5: P[i]=Transform(Qui[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                                   //long
         case  6: P[i]=Transform(Ql[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                          //unsigned long
         case  7: P[i]=Transform(Qul[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                              //long long
         case  8: P[i]=Transform(Qll[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                           //unsigned l l
         case  9: P[i]=Transform(Qull[i],LeafMin[i],LeafMax[i],Chan[i]); break;                                  //float
         case 10: P[i]=Transform(Qf[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                                 //double
         case 11: P[i]=Transform(Qd[i],LeafMin[i],LeafMax[i],Chan[i]);
         }
      }
   ProcessEvent(P,0);
   }
Delta=iEnd-iStart; (*EvtsRead)+=Delta; (*FracRead)=(float)Delta/NEntries;
return 0;
}
//----------------------------------------------------------------------------------------------------------------------
int ReadRootBlockForReWrite(int BufNo,int NPar,int *Chan,long *EvtsRead,int *NewEvts,float *FracRead,
    int NTot,int *Select,unsigned short *OutBuf)
//Reads a block of ROOT data. Return 0 normally, 1 if no more data
{
Long64_t iEvt,NEntries,iStart,iEnd,Delta;
int i,SkipEvent,NewBufPtr;
unsigned short P[MAX_PAR]; 
char Qc[MAX_PAR]; unsigned char Quc[MAX_PAR]; short Qs[MAX_PAR]; unsigned short Qus[MAX_PAR];
int Qi[MAX_PAR]; unsigned int Qui[MAX_PAR]; long Ql[MAX_PAR]; unsigned long Qul[MAX_PAR];
long long Qll[MAX_PAR]; unsigned long long Qull[MAX_PAR]; float Qf[MAX_PAR]; double Qd[MAX_PAR];

NEntries=Tree->GetEntriesFast();
iStart=EVTS_PER_BUF*BufNo; if (iStart>NEntries) return 1;
iEnd=iStart+EVTS_PER_BUF; if (iEnd>NEntries) iEnd=NEntries;
for (i=0;i<NPar;++i)                                                  //Declare location in memory where entries will go
   {
   switch (LType[i])
      {
      case  0: Tree->SetBranchAddress(LeafName[i],&Qc[i]); break;                                                 //char
      case  1: Tree->SetBranchAddress(LeafName[i],&Quc[i]); break;                                       //unsigned char
      case  2: Tree->SetBranchAddress(LeafName[i],&Qs[i]); break;                                                //short
      case  3: Tree->SetBranchAddress(LeafName[i],&Qus[i]); break;                                      //unsigned short
      case  4: Tree->SetBranchAddress(LeafName[i],&Qi[i]); break;                                                  //int
      case  5: Tree->SetBranchAddress(LeafName[i],&Qui[i]); break;                                        //unsigned int
      case  6: Tree->SetBranchAddress(LeafName[i],&Ql[i]); break;                                                 //long
      case  7: Tree->SetBranchAddress(LeafName[i],&Qul[i]); break;                                       //unsigned long
      case  8: Tree->SetBranchAddress(LeafName[i],&Qll[i]); break;                                           //long long
      case  9: Tree->SetBranchAddress(LeafName[i],&Qull[i]); break;                                 //unsigned long long
      case 10: Tree->SetBranchAddress(LeafName[i],&Qf[i]); break;                                                //float
      case 11: Tree->SetBranchAddress(LeafName[i],&Qd[i]);                                                      //double
      }
   }
for (iEvt=iStart,(*NewEvts)=0,NewBufPtr=0;iEvt<iEnd;++iEvt)                                      //Loop over events
   {
   Tree->GetEntry(iEvt);
   for (i=0;i<NPar;++i)
      {
      switch (LType[i])
         { 
         case  0: P[i]=Transform(Qc[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                                   //char
         case  1: P[i]=Transform(Quc[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                          //unsigned char
         case  2: P[i]=Transform(Qs[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                                  //short
         case  3: P[i]=Transform(Qus[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                                    //int
         case  4: P[i]=Transform(Qi[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                           //unsigned int
         case  5: P[i]=Transform(Qui[i],LeafMin[i],LeafMax[i],Chan[i]);  break;                                   //long
         case  6: P[i]=Transform(Ql[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                          //unsigned long
         case  7: P[i]=Transform(Qul[i],LeafMin[i],LeafMax[i],Chan[i]);  break;              //long long
         case  8: P[i]=Transform(Qll[i],LeafMin[i],LeafMax[i],Chan[i]);  break;           //unsigned l l
         case  9: P[i]=Transform(Qull[i],LeafMin[i],LeafMax[i],Chan[i]); break;                  //float
         case 10: P[i]=Transform(Qf[i],LeafMin[i],LeafMax[i],Chan[i]);   break;                 //double
         case 11: P[i]=Transform(Qd[i],LeafMin[i],LeafMax[i],Chan[i]);
         }
      }
   ProcessEvent(P,1);
   for (i=0,SkipEvent=1;i<NTot;++i) if ((Select[i]) && (P[i]>0)) { SkipEvent=0; break; }
   if (!SkipEvent)                                               //Skip event if all relevant parameters are zero
      {
      ++(*NewEvts);
      for (i=0;i<NTot;++i) if (Select[i]) OutBuf[NewBufPtr++]=P[i];
      }
   }
Delta=iEnd-iStart; (*EvtsRead)+=Delta; (*FracRead)=(float)Delta/NEntries;
return 0;
}
//----------------------------------------------------------------------------------------------------------------------
void CloseRootFileForAnalysis(void)
{ Tf->Close(); }
//----------------------------------------------------------------------------------------------------------------------

