!-----Read and write Radware 1d files in .spe format
#include "constants.h"
SUBROUTINE RADR16(FNAME,L,ISPEC,NREQ,NCHAN)
! Read Radware file and convert to 16-bit 1d spectrum
! NREQ=No of channels required, NCHAN=No of channels actually in file
INTEGER*2 ISPEC(NREQ)
CHARACTER*MAX_FNAME_LENGTH FNAME,FNAM
CHARACTER*8 NAMESP
REAL SPEC(16384)

FNAM=FNAME(1:L)
DO I=1,16384; SPEC(I)=0; ENDDO; DO I=1,NREQ; ISPEC(I)=0; ENDDO
OPEN(1,FILE=FNAM,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
READ(1) NAMESP,NCHAN,IDUM,IDUM,IDUM
READ(1) (SPEC(I),I=1,NCHAN)
CLOSE(1)
DO I=1,NREQ
   IF (SPEC(I).LT.0.) THEN; ISPEC(I)=0
   ELSE; ISPEC(I)=SPEC(I); ENDIF
ENDDO
END
!----------------------------------------------------------------------
SUBROUTINE RADR32(FNAME,L,ISPEC,NREQ,NCHAN)
! Read Radware file and convert to 32-bit 1d spectrum
! NREQ=No of channels required, NCHAN=No of channels actually in file
INTEGER*4 ISPEC(NREQ)
CHARACTER*MAX_FNAME_LENGTH FNAME,FNAM
CHARACTER*8 NAMESP
REAL SPEC(16384)

FNAM=FNAME(1:L)
DO I=1,16384; SPEC(I)=0; ENDDO; DO I=1,NREQ; ISPEC(I)=0; ENDDO
OPEN(1,FILE=FNAM,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
READ(1) NAMESP,NCHAN,IDUM,IDUM,IDUM
READ(1) (SPEC(I),I=1,NCHAN)
CLOSE(1)
DO I=1,NREQ
   IF (SPEC(I).LT.0.) THEN; ISPEC(I)=0
   ELSEIF (ISPEC(I).GT.2.1E9) THEN; ISPEC(I)=2147483647
   ELSE; ISPEC(I)=SPEC(I); ENDIF
ENDDO
END
!----------------------------------------------------------------------
SUBROUTINE RADW16(FNAME,L,ISPEC,NCHAN,NAMESP,M)
! Convert 16-bit 1d spectrum to REAL and write to Radware spectrum
INTEGER*2 ISPEC(NCHAN)
CHARACTER*MAX_FNAME_LENGTH FNAME,FNAM
CHARACTER*8 NAMESP,NAMEX
REAL SPEC(NCHAN)

FNAM=FNAME(1:L)
WRITE(NAMEX,'(A8)')NAMESP(1:M)
DO I=1,NCHAN; SPEC(I)=ISPEC(I); ENDDO
OPEN(1,FILE=FNAM,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
WRITE(1) NAMEX,NCHAN,1,1,1
WRITE(1) SPEC
CLOSE(1)
END
!----------------------------------------------------------------------
SUBROUTINE RADW32(FNAME,L,ISPEC,NCHAN,NAMESP,M)
! Convert 32-bit 1d spectrum to REAL and write to Radware spectrum
INTEGER*4 ISPEC(NCHAN)
CHARACTER*MAX_FNAME_LENGTH FNAME,FNAM
CHARACTER*8 NAMESP,NAMEX
REAL SPEC(NCHAN)

FNAM=FNAME(1:L)
WRITE(NAMEX,'(A8)')NAMESP(1:M)
DO I=1,NCHAN; SPEC(I)=ISPEC(I); ENDDO
OPEN(1,FILE=FNAM,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
WRITE(1) NAMEX,NCHAN,1,1,1
WRITE(1) SPEC
CLOSE(1)
END
!----------------------------------------------------------------------
