#include <inttypes.h>
#include <stdint.h>
#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/vfs.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <time.h>
#include <sys/time.h>
#include <sys/stat.h>
#include "lamps.h"
#include "common.h"

//Function Templates
void SAttention(gchar *Messg);
void Attention(gint XPos,gchar *Messg);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void ProcessEvent(gushort *P,gboolean Option);
void ZeroOned(gint SNo); void ZeroTwod(gint SNo);
void RefreshAll(void);
void Safety(gchar *RunName,gdouble *ElapsedTime,gint *SpecSaved);
void PeriodicLog(gint Status,gchar *RunName,glong BuffersAcquired,glong BuffersProcessed,
                 glong BytesWritten,time_t TStart,gdouble StartTime,guint32 *ScalerBuf);
void Write1d(gchar *FName,gint i,gboolean InThread);
void Write2d32(gchar *FName,gint i,gboolean InThread);
void Write2d16(gchar *FName,gint i,gboolean InThread);
void CorrectScaler(gint No);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
gboolean writeEventBlock(gint eventSize,gint ev_per_block,gushort data[],FILE *Fp);
void writeNames(int noOfAdcs,int noOfSingles,int noOfScalers,FILE *Fp);
void queue_text(enum blocktype block,gchar *txt,FILE *Fp);
void writeEndOfFile(FILE *Fp);
gint Read(gchar *ErrMessg); void StopNicely(void);
void fstart_(gchar *RunName,int Len); void fstop_();
void ComputeMacros(glong BuffersAcquired,FILE *MacroFp);
void FileOpenNew(gchar *Title,GtkWidget *Parent,gint X,gint Y,gboolean OpenToRead,gchar *StartPath,gchar *Mask,
                 gboolean MaskEditable,void (*CallBack)(GtkWidget *,gpointer),gboolean Persist);
int SimulateRead(gushort *AcqBuf,guint32 *ScalerBuf);
void OpenRootFile(char *FName,int NPar,char [][MAX_TEXT_FIELD],char *TreeNam);
void WriteRootBlock(unsigned short *AcqBuf,int NEvt,int NPar);
void CloseRootFile(void);

//External global variables
extern gushort AcqBuf1[MAX_BUFSIZ],AcqBuf2[MAX_BUFSIZ];                                        //Two acquisition buffers
extern guint32 ScalerBuf1[MAX_SCALER],ScalerBuf2[MAX_SCALER];                           //Buffers containing Scaler data
extern guint32 ScalerCurr[MAX_SCALER],ScalerPrev[MAX_SCALER];      //Scaler values from the current and previous buffers
extern guint32 ScalerOverflows[MAX_SCALER];                                    //The number of overflows for each scaler
extern guint32 ScalerPending[MAX_SCALER];                                                    //Scaler values after Pause
extern struct Setup Setup;                                                                         //The setup variables
//extern enum V775TdcMode V775TdcMode;
extern enum ProgramState ProgramState;                                        //The current running state of the program
extern gchar RunName[120],PrevRun[120];                                           //Name of current run and previous run
extern enum AcqSignal AcqSignal;                                                                 //Stop,Pause and Resume
extern GtkWidget *S_Stat[15],*S_Scaler[4];                                                          //Status bar widgets
extern gint RefreshRate,RefreshOptimum;      //The interval (no. of buffers) for screen refreshes, RefreshOptimum=1 or 0
extern gchar SStop[120];                                            //The stop time of time of this, or the previous run
extern gint ScalerWinOpen;
extern GtkWidget **ScalerTotal,**ScalerRate,**ScalerDRate;
extern gboolean BatchRunning;
extern gfloat MacroCurr[MAX_MACRO],MacroPrev[MAX_MACRO],MacroDiff[MAX_MACRO];                //Computed values of macros
extern glong BytesWritten;
extern struct FileSelectType *FileX;
extern gchar SetupDir[MAX_DIR_STRLEN],ListFDir[MAX_DIR_STRLEN],SpecDir[MAX_DIR_STRLEN],
      BatDir[MAX_DIR_STRLEN],LogDir[MAX_DIR_STRLEN],MacroDir[MAX_DIR_STRLEN];                                //Dir prefs
extern gboolean Simulate;
extern GtkWidget *PrevWin;                               //Defined global in main.c. Used by setup.c, macro.c, control.c

//Global Variables used in this file only (except BuffersAcquired, used also in batch.c)
glong BuffersAcquired,BuffersProcessed,BufPrev,BytesPrev;                      //BuffersAcquired is also used in batch.c
gshort NPar1,NPar2;                                                                    //No. of parameters in each crate
gdouble TimePrev,StartTime,PauseDuration,PauseTime;
FILE *LogFp,*ScalerFp;                                                   //The ascii log files: lamps.log and scaler.log
time_t TStart;
unsigned long long BytesAcquired;
gint NoOfModules,BytesRecv;
gushort EvtSize;
gint NoOfSubAddr[2*MAX_VME_STNS];
gint ParaNo[32][32];                                                           //ParaNo[GeographicalAddress][SubAddress]
gint GeoAddr[MAX_PAR];
gint NoOfCAENDigitizerModule,NoOfMesytecDigitizerModule;
gint NoOfCAENParameters;       //Total no. of params in CAEN modules. Would be used to calculate no. of CBLT cycle later

//Function templates
void CreateDir(void);
gint TcpConnect(gchar *EthAddr,gint EthPort);

//Function templates and global variables for threads
void *AcquireData(gpointer Data); void *BuildSpectra(void *Data);
pthread_t Acq,Spec,CntlBat,AStop;
//----------------------------------------------------------------------------------------------------------------------
void Pad(gchar *Str,gint N)                                          //Adds blanks to Str making it exactly N chars long
{
gint i;

for (i=strlen(Str);i<N;++i) Str[i]=' '; Str[N]='\0'; return;
}
//----------------------------------------------------------------------------------------------------------------------
void StopAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void SendStopAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void StartAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void PauseAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void ResumeAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void CorrectScaler(gint i)                                                                     //Correction for overflow
{
if (ScalerCurr[i]<ScalerPrev[i]) { ScalerOverflows[i]++; ScalerCurr[i]+=SCALER_OVERFLOW; }
}
//----------------------------------------------------------------------------------------------------------------------
void UpdateDisplay(gdouble *ElapsedTime,gboolean Scribe,guint32 *ScalerBuf)
{
struct timeval Tv;
gdouble TimeNow,Kbps,Evtps,DelTime,DKbps,DEvtps,DeadTime;
gchar SDFree[60],SKbps[60],SEvtps[60],SBytes[60],SZSup[60],SBuffs[60],SProc[60],SElap[60],Str[255],SScaler[4][60],
      SEvts[60],SDead[60],NameF[MAX_DIR_STRLEN+20];
gulong DelBytes,EventsAcquired,Masters,DMasters,DEvents;
struct tm *TmStop;
time_t TStop;
struct statfs StatBuf;
gfloat DFree;
gint i;

gettimeofday(&Tv,NULL); TimeNow=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
*ElapsedTime=TimeNow-StartTime-PauseDuration;
EventsAcquired=BytesAcquired/2/Setup.Parameter.NPar;
Kbps=1.0e-03*BytesAcquired/(*ElapsedTime);
DelTime=TimeNow-TimePrev; DelBytes=BytesAcquired-BytesPrev;
DKbps=1.e-03*DelBytes/DelTime; DEvtps=0.5*DelBytes/Setup.Parameter.NPar/DelTime;
if (RefreshOptimum) RefreshRate=(gint)MAX(2.0e03*DKbps/Setup.ListMode.BufSiz,0.1)*10;               //20 sec base value
if (Kbps>.1) sprintf(SKbps,"Kb/s: %.2f (%.2f)",Kbps,DKbps); else sprintf(SKbps,"Kb/s: %.2e (%.2e)",Kbps,DKbps);
Evtps=0.5*BytesAcquired/Setup.Parameter.NPar/(*ElapsedTime);
if (Evtps<1.0e3) sprintf(SEvtps,"Evt/s: %.2f",Evtps); else sprintf(SEvtps,"Evt/s: %.2fK",1.0e-3*Evtps);
if (DEvtps<1.0e3) sprintf(Str," (%.2f)",DEvtps); else sprintf(Str," (%.2fK)",1.0e-3*DEvtps);
strcat(SEvtps,Str);
sprintf(SElap,"Elapsed: %.1f s",*ElapsedTime);
sprintf(SBytes,"BytesAcqd.: %llu",BytesAcquired);
sprintf(SBuffs,"Buffs Acq: %ld",BuffersAcquired); sprintf(SProc,"Processed: %ld",BuffersProcessed);
sprintf(SEvts,"EventsAcq: %lu",EventsAcquired);
for (i=0;i<Setup.Scaler.NSc;++i)
   {
   ScalerPrev[i]=ScalerCurr[i];
   ScalerCurr[i]=ScalerBuf[i];
   //g_print("ScalerBuf[i=%d]=%u, ScalerCurr=%u, ScalerPrev=%u \n",i,ScalerBuf[i],ScalerCurr[i],ScalerPrev[i]);
   }
if (Setup.Scaler.Master>-1)
   {
   Masters=ScalerCurr[Setup.Scaler.Master]+ScalerPending[Setup.Scaler.Master];
   if (Masters) DeadTime=100.0*(1.0-(gdouble)EventsAcquired/(gdouble)Masters); else DeadTime=0.0;
   if (DeadTime<0.0) DeadTime=0.0;
   sprintf(SDead,"Dead  Time: %.1f%%",DeadTime);
   DMasters=ScalerCurr[Setup.Scaler.Master]-ScalerPrev[Setup.Scaler.Master];
   DEvents=0.5*DelBytes/Setup.Parameter.NPar;
   if (DMasters && (AcqSignal==Resume) && EventsAcquired)
      { sprintf(Str," (%.1f%%)",100.0*(1.0-(gdouble)DEvents/(gdouble)DMasters)); strcat(SDead,Str); }
   }
TimePrev=TimeNow; BufPrev=BuffersAcquired; BytesPrev=BytesAcquired;
if (Setup.ListMode.ListOn) sprintf(SZSup,"Z.Sup Bytes: %ld",BytesWritten);
for (i=0;i<MIN(4,Setup.Scaler.NSc);++i) sprintf(SScaler[i],"%s:%d",Setup.Scaler.Name[i],ScalerCurr[i]+ScalerPending[i]);

if (AcqSignal==Pause)
   {
   sprintf(NameF,"%s/scaler.log",LogDir); ScalerFp=fopen(NameF,"a");
   fprintf(ScalerFp,"Pause:%s Elapsed sec: %.1f\n",ctime(&TStop),*ElapsedTime);
   fclose(ScalerFp);
   }

if (Scribe)
   {
   TStop=time(NULL); TmStop=localtime(&TStop);
   sprintf(SStop,"Stop: %02d:%02d:%02d",TmStop->tm_hour,TmStop->tm_min,TmStop->tm_sec);
   sprintf(NameF,"%s/lamps.log",LogDir);
   if ((LogFp=fopen(NameF,"a"))==NULL)                                        //Open log file and make the final entries
      {
      SAttention("Couldnt open log file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   strcpy(Str,ctime(&TStop)); Str[24]='\0'; Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Stop:",Str);
   sprintf(Str,"%.1f",*ElapsedTime);        Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Elapsed sec:",Str);
   sprintf(Str,"%ld",BuffersAcquired);      Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Buffers Acquired:",Str);
   sprintf(Str,"%ld",BuffersProcessed);     Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Buffers Processed:",Str);
   sprintf(Str,"%ld",EventsAcquired);       Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Events:",Str);
   sprintf(Str,"%.2f",Evtps);               Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Evt/s:",Str);
   if (Setup.Scaler.Master>-1) sprintf(Str,"%.1f%%",DeadTime); else sprintf(Str,"-");
                                            Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Dead Time:",Str);
   if (Setup.ListMode.ListOn) sprintf(Str,"%ld",BytesWritten); else sprintf(Str,"No list");
                                            Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","List Bytes:",Str);
   for (i=0;i<4;i++)                  //We always write only 4 scaler values here. All scalers are written to scaler.log
       {
       if (i<=Setup.Scaler.NSc) sprintf(Str,"%d",ScalerCurr[i]+ScalerPending[i]); else sprintf(Str,"0");
       Pad(Str,30); fprintf(LogFp,"%-6s%02d: %13s %s}\n","Scaler",i+1," ",Str);
       }
   fprintf(LogFp,"-------------------------------------------------------\n");
   fclose(LogFp);

   sprintf(NameF,"%s/scaler.log",LogDir);
   if ((ScalerFp=fopen(NameF,"a"))==NULL)                              //Open scaler log file and make the final entries
      {
      SAttention("Couldnt open log file scaler.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   if (AcqSignal==Stop) fprintf(ScalerFp,"Stop: %s Elapsed sec: %.1f\n",ctime(&TStop),*ElapsedTime);
   for (i=0;i<Setup.Scaler.NSc;++i)
       fprintf(ScalerFp,"Scaler%02d %s %d\n",i+1,Setup.Scaler.Name[i],ScalerCurr[i]+ScalerPending[i]);
   fprintf(ScalerFp,"-------------------------------------------------------\n");
   fclose(ScalerFp);
   }

gdk_threads_enter();
gtk_label_set_text(GTK_LABEL(S_Stat[ 9]),SKbps);
gtk_label_set_text(GTK_LABEL(S_Stat[10]),SEvtps);
gtk_label_set_text(GTK_LABEL(S_Stat[11]),SBytes);
gtk_label_set_text(GTK_LABEL(S_Stat[13]),SEvts);
if (Setup.Scaler.Master>-1) gtk_label_set_text(GTK_LABEL(S_Stat[14]),SDead);
if (Setup.ListMode.ListOn)
   {
   statfs("./",&StatBuf);
   DFree=(gfloat)StatBuf.f_bavail*StatBuf.f_bsize/1024.0/1024.0/1024.0; sprintf(SDFree,"Free: %-3.3fGb",DFree);
   if (DFree<1.0) { DFree=1024.0*DFree; sprintf(SDFree,"Free: %-3.1fMb",DFree); }
   if (DFree<1.0) { DFree=1024.0*DFree; sprintf(SDFree,"Free: %-3.1fKb",DFree); }
   gtk_label_set_text(GTK_LABEL(S_Stat[2]),SDFree);                                                 //Free space on disk
   gtk_label_set_text(GTK_LABEL(S_Stat[12]),SZSup);                                                        //Z.Sup Bytes
   }
gtk_label_set_text(GTK_LABEL(S_Stat[ 7]),SBuffs);
gtk_label_set_text(GTK_LABEL(S_Stat[ 8]),SProc);
gtk_label_set_text(GTK_LABEL(S_Stat[ 5]),SElap);
for (i=0;i<MIN(4,Setup.Scaler.NSc);i++) gtk_label_set_text(GTK_LABEL(S_Scaler[i]),SScaler[i]);
if (AcqSignal == Stop)
   { gtk_label_set_text(GTK_LABEL(S_Stat[6]),SStop); gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Status: Free"); }
if (BatchRunning)
   { sprintf(Str,"Batch: %d/%d",Setup.BatAcq.Current,Setup.BatAcq.NBat); gtk_label_set_text(GTK_LABEL(S_Stat[0]),Str); }
RefreshAll();
if (ScalerWinOpen)
   {
   for (i=0;i<Setup.Scaler.NSc;++i)
       {
       sprintf(Str,"%d",ScalerCurr[i]+ScalerPending[i]);
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerTotal[i])->child),Str);
       if (*ElapsedTime>0.5) sprintf(Str,"%.1f",(gdouble)(ScalerCurr[i]+ScalerPending[i])/(*ElapsedTime));
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerRate[i])->child),Str);
       if (*ElapsedTime>0.5) sprintf(Str,"%.1f",(gdouble)(ScalerCurr[i]-ScalerPrev[i])*RefreshRate/DelTime);
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerDRate[i])->child),Str);
       }
   }
gdk_threads_leave();
}
//----------------------------------------------------------------------------------------------------------------------
void ZlsError(void)
{
SAttention("Error: Disk Full...Acq Stopped!");
StopNicely();
}
//----------------------------------------------------------------------------------------------------------------------
gboolean CheckLGates(gushort *Par)                                                              //Checks list mode gates
{
gint i;

for (i=0;i<Setup.ListMode.NoOfLGates;++i)
    {
    if ((Par[Setup.ListMode.LGates[i].Para-1] < Setup.ListMode.LGates[i].Lo) ||
        (Par[Setup.ListMode.LGates[i].Para-1] > Setup.ListMode.LGates[i].Hi)) return FALSE;
    }
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
gint CompressToDisk(FILE *Fp,gushort *AcqBuf)                              //zls, candle and csv formats are implemented
{
gint i,j,k,l,m,NEvt,Ptr1,Ptr2,CPtr,CBufSiz,HdrWds;
gushort Par[MAX_PAR];
gushort CompBuf[2*MAX_BUFSIZ];                            //The compressed buffer can be larger than AcqBuf[65536 words]
gushort BitMask[MAX_HDR];                                              //The event masks, 1 mask for every 16 parameters
static gchar Sign[4] = {"DAPS"};
gboolean AcceptEvent;                               //If all parameters are outside [LLD,ULD] we reject the entire event

NEvt=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;                                                    //Number of events
switch (Setup.ListMode.Compr)                                                           //zls=1; ROOT=2; candle=0; csv=3
   {
   case 0:                                   //IUAC Freedom format. Here CompBuf is used to hold the crate combined data
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,CPtr=0;i<NEvt;++i)
               {
               for (j=0;j<NPar1;++j) CompBuf[CPtr+j]=AcqBuf[Ptr1+j];
               CPtr+=NPar1;
               for (j=0;j<NPar2;++j) CompBuf[CPtr+j]=AcqBuf[Ptr2+j];
               CPtr+=NPar2;
               Ptr1+=NPar1; Ptr2+=NPar2;
               }
           if (!writeEventBlock(Setup.Parameter.NPar,NEvt,CompBuf,Fp)) { ZlsError(); return FALSE; }
           break;
   case 1:                                                                                           //Normal zls format
           HdrWds=(Setup.Parameter.NPar+15)/16;
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,CPtr=0,AcceptEvent=FALSE;i<NEvt;++i)            //Loop over events in AcqBuf
               {
               for (j=0;j<HdrWds;++j) BitMask[j]=0;
               for (j=0,m=0;j<Setup.Parameter.NPar;++j)
                   {
                   k=j/16; l=j%16;
                   if (j<NPar1) Par[j]=AcqBuf[Ptr1+j]; else Par[j]=AcqBuf[Ptr2+j-NPar1];
                   if ((Par[j] >= Setup.Parameter.LLD[j]) && (Par[j] <= Setup.Parameter.ULD[j]))
                      { AcceptEvent=TRUE; BitMask[k]|=1<<l; CompBuf[CPtr+HdrWds+m]=Par[j]; m++; }
                   }
               if (Setup.ListMode.NoOfLGates) if (!CheckLGates(Par)) AcceptEvent=FALSE;                //Gated List Mode
               if (AcceptEvent)
                  {
                  for (j=0;j<HdrWds;++j) CompBuf[CPtr+j]=BitMask[j];
                  CPtr+=HdrWds+m;
                  }
               Ptr1+=NPar1; Ptr2+=NPar2;
               }
           CBufSiz=2*CPtr;
           if (fwrite(Sign,4,1,Fp)<1) { ZlsError(); return FALSE; }
           if (fwrite(&CBufSiz,4,1,Fp)<1) { ZlsError(); return FALSE; }
           if (fwrite(CompBuf,2,CPtr,Fp)<CPtr) { ZlsError(); return FALSE; }
           BytesWritten+=(8+2*CPtr);
           break;
   case 2: break;                                               //Code wont reach here. ROOT format is handled elsewhere
   case 3:                                                                                            //Excel csv format
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,AcceptEvent=FALSE;i<NEvt;++i)
              {
              for (j=0;j<Setup.Parameter.NPar;++j)
                 {
                 if (j<NPar1) Par[j]=AcqBuf[Ptr1+j]; else Par[j]=AcqBuf[Ptr2+j-NPar1];
                 if ((Par[j] >= Setup.Parameter.LLD[j]) && (Par[j] <= Setup.Parameter.ULD[j])) AcceptEvent=TRUE;
                 }
              if (AcceptEvent)
                 {
                 for (j=0;j<Setup.Parameter.NPar;++j)
                     {
                     if (j<Setup.Parameter.NPar-1) fprintf(Fp,"%d,",Par[j]);
                     else fprintf(Fp,"%d\n",Par[j]);
                     }
                 }
                 Ptr1+=NPar1; Ptr2+=NPar2;
              }
   }
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
void *BuildSpectra(void *Data)
{
gushort *AcqBuf;
gushort Para[MAX_TOTAL_PAR];
gint Evt,i,Ptr1,EventsPerBuf;

EventsPerBuf=BytesRecv/2/Setup.Parameter.NPar; AcqBuf=(gushort *)Data;
//for (i=0;i<BytesRecv/2;++i) {if (((i==3) || (i==35))&& (AcqBuf[i]!=0))  g_print("i=%d, Data=%d\n",i, AcqBuf[i]);}
for (Evt=0,Ptr1=0;Evt<EventsPerBuf;Evt++)
    {
    for (i=0;i<Setup.Parameter.NPar;++i) {Para[i]=AcqBuf[Ptr1+i];}
    ProcessEvent(Para,FALSE); Ptr1+=Setup.Parameter.NPar;
    //for (i=0;i<Setup.Parameter.NPar;++i) {if (Para[i]==24064) g_print("Para[%d]=%d\n",i, Para[i]);}
    }
BuffersProcessed++;
//g_print("End of build Spectra...BuffersProcessed=%ld\n",BuffersProcessed);
pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void *ControlAutoStop(gpointer Unused)
{ sleep(Setup.Hardware.AutoStop); StopNicely(); pthread_exit(NULL); return NULL;}
//----------------------------------------------------------------------------------------------------------------------
void *AcquireData(gpointer Data)                                    //Data acquisition thread triggered by StartCallBack
{
gint i,j,SpecSaved,NewBufs;
gchar FNam[2048],Str[256],NSC_txt[256],FileMode[10];
gchar NameF[MAX_DIR_STRLEN+20];
glong CollectedEvents;
FILE *ListFp,*MacroFp;
struct timeval Tv;
gdouble ElapsedTime;
struct tm *TmStart;
gushort *AcqBuf;
guint32 *ScalerBuf;
char ParName[MAX_PAR][MAX_TEXT_FIELD];

for (i=0,NPar1=NPar2=0;i<Setup.Parameter.NPar;++i) { if (Setup.Parameter.N[i]>MAX_VME_STNS) ++NPar2; else ++NPar1; }

if (Setup.ListMode.ListOn)
   {
   switch (Setup.ListMode.Compr)
      {
      case 0: sprintf(FNam,"%s/%s.001",ListFDir,RunName); break;                               //IUAC Candle file format
      case 1: sprintf(FNam,"%s/%s.zls",ListFDir,RunName); break;         //Normal: The usual zls zero suppression scheme
      case 2: sprintf(FNam,"%s/%s.root",ListFDir,RunName); break;                                                 //ROOT
      case 3: sprintf(FNam,"%s/%s.csv",ListFDir,RunName);                                                          //csv
      }
   if (AcqSignal==Pause) strcpy(FileMode,"a"); else strcpy(FileMode,"w");            //If run was paused use append mode
   if (Setup.ListMode.Compr==0 || Setup.ListMode.Compr==1 || Setup.ListMode.Compr==3)
      {   
      if ((ListFp=fopen(FNam,FileMode))==NULL)
         {
         SAttention("Couldnt open List File\nFile permissions problem or disk full?");
         ProgramState=Free; pthread_exit(NULL);
         }
      }
   else
      {
      for (i=0;i<Setup.Parameter.NPar;++i) strcpy(ParName[i],Setup.Parameter.Name[i]);
      OpenRootFile(FNam,Setup.Parameter.NPar,ParName,"");
      }
   if (AcqSignal!=Pause) BytesWritten=0;
   if (Setup.ListMode.Compr==0)                                                                //IUAC Candle file header
      {
      if (AcqSignal==Pause)
         { sprintf(NSC_txt,"RESUME: %s resumed. Run #%04d\n",RunName,111); queue_text(resume,NSC_txt,ListFp); }
      else
         {
         sprintf(NSC_txt,"%s\n %s\n %s\n","LAMPS","A.Chatterjee","Candle Compatible File");
         queue_text(user,NSC_txt,ListFp); writeNames(Setup.Parameter.NPar,0,0,ListFp);
         sprintf(NSC_txt,"START : %s started. Run #%04d\n",RunName,111); queue_text(start,NSC_txt,ListFp);
         }
      }
   }

if (Setup.Macro.N)
   {
   sprintf(FNam,"%s/%s.mac",MacroDir,RunName);
   if ((MacroFp=fopen(FNam,"w"))==NULL)
      {
      SAttention("Couldnt open file for macro dump\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   }

if (AcqSignal!=Pause)
   { gettimeofday(&Tv,NULL); StartTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06; TStart=time(NULL); }
TmStart=localtime(&TStart);
gdk_threads_enter();
gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Status: Acquiring");
gtk_label_set_text(GTK_LABEL(S_Stat[3]),RunName);
sprintf(Str,"Start: %02d:%02d:%02d",TmStart->tm_hour,TmStart->tm_min,TmStart->tm_sec);
gtk_label_set_text(GTK_LABEL(S_Stat[4]),Str);
sprintf(Str,"Prev. %s",SStop); gtk_label_set_text(GTK_LABEL(S_Stat[6]),Str);
gdk_threads_leave();

if (Setup.Macro.N)
   {
   fprintf(MacroFp,"#Macro file %s.mac opened at %02d:%02d:%02d\n",RunName,TmStart->tm_hour,TmStart->tm_min,
                    TmStart->tm_sec);
   fprintf(MacroFp,"#The following macros are shown as a function of buffer number in the table below\n");
   for (i=0,j=0;i<Setup.Macro.N;++i)
       {
       MacroCurr[i]=MacroPrev[i]=MacroDiff[i]=0.0;
       if (Setup.Macro.Display[i]) { fprintf(MacroFp,"# %s %s-diff",Setup.Macro.Name[i],Setup.Macro.Name[i]); ++j; }
       if (!((j+1)%4)) fprintf(MacroFp,"\n");
       }
    fprintf(MacroFp,"\n");
    }

gdk_threads_enter(); RefreshAll();
gtk_label_set_text(GTK_LABEL(S_Stat[5]),""); for (i=7;i<15;++i) gtk_label_set_text(GTK_LABEL(S_Stat[i]),"");
gdk_threads_leave();

sprintf(NameF,"%s/lamps.log",LogDir);
if ((LogFp=fopen(NameF,"r"))==NULL)
   {                                                                                   //No log file...so make a new one
   if ((LogFp=fopen(NameF,"w"))==NULL)                                //Create log file and write default headings in it
      {
      SAttention("Couldnt create file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   fprintf(LogFp,"Ion, q+             \nE, TV               \nNMR, I              \nCI (scale)          \n");
   fprintf(LogFp,"Target              \nTgt. Rot.           \nInfo 1              \nInfo 2              \n");
   fprintf(LogFp,"Info 3              \nInfo 4              \nInfo 5              \nInfo 6              \n");
   fprintf(LogFp,"-------------------------------------------------------\n");
   fclose(LogFp);
   }
else fclose(LogFp);

if (AcqSignal!=Pause)
   {
   sprintf(NameF,"%s/lamps.log",LogDir);
   if ((LogFp=fopen(NameF,"a"))==NULL)                                //Open log file and make the initial entries in it
      {
      SAttention("Couldnt open log file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   sprintf(Str,"%s",RunName); Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","Run Name:",Str);
   AbbreviateFileName(Str,Setup.FName,MAX_FNAME_LENGTH); if (Setup.Modified) strcat(Str,"(?)");
   if (!strlen(Setup.FName)) sprintf(Str,"%s","none");
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","Setup File:",Str);
   strcpy(Str,ctime(&TStart)); Str[24]='\0'; Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Start:",Str);
   if (Setup.Oned.WSz==1) sprintf(Str,"%d 16-bit",Setup.Oned.N); else sprintf(Str,"%d 32-bit",Setup.Oned.N);
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","1d_Spec:",Str);
   if (Setup.Twod.WSz==1) sprintf(Str,"%d 16-bit",Setup.Twod.N); else sprintf(Str,"%d 32-bit",Setup.Twod.N);
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","2d_Spec:",Str);
   fprintf(LogFp,"%-23s %30s}\n","User  1:"," "); fprintf(LogFp,"%-23s %30s}\n","User  2:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  3:"," "); fprintf(LogFp,"%-23s %30s}\n","User  4:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  5:"," "); fprintf(LogFp,"%-23s %30s}\n","User  6:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  7:"," "); fprintf(LogFp,"%-23s %30s}\n","User  8:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  9:"," "); fprintf(LogFp,"%-23s %30s}\n","User 10:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User 11:"," "); fprintf(LogFp,"%-23s %30s}\n","User 12:"," ");
   fprintf(LogFp,"%-23s %40s]\n","Remarks 1:"," "); fprintf(LogFp,"%-23s %40s]\n","Remarks 2:"," ");
   fprintf(LogFp,"%-23s %40s]\n","Remarks 3:"," "); fprintf(LogFp,"%-23s %40s]\n","Remarks 4:"," ");
   fclose(LogFp);
   }

if (AcqSignal==Pause) PeriodicLog(4,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
else
   {
   BuffersProcessed=0; BuffersAcquired=0; BufPrev=0; NewBufs=0; BytesPrev=0;
   PeriodicLog(0,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
                                                                                          //periodic.log initial entries
   sprintf(NameF,"%s/scaler.log",LogDir);
   if ((ScalerFp=fopen(NameF,"a"))==NULL)                                //Open scaler log file and make initial entries
      {
      SAttention("Couldnt open log file scaler.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   fprintf(ScalerFp,"%s Start:%s\n",RunName,ctime(&TStart));
   fclose(ScalerFp);
   }

if (Setup.Hardware.AutoStopOn) pthread_create(&AStop,NULL,ControlAutoStop,NULL);                   //Thread for Autostop

if (AcqSignal==Stop) StartAcq(); else if (AcqSignal==Pause) ResumeAcq();
ElapsedTime=0.0; SpecSaved=0;
if (AcqSignal!=Pause) BytesAcquired=0;
AcqSignal=Resume;                                                          //We set this when acquisition is in progress
ScalerBuf=ScalerBuf1;
for (i=0;i<Setup.Scaler.NSc;++i) { ScalerBuf[i]=0; ScalerPrev[i]=0; ScalerCurr[i]=0; }
UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);

//Simulation block starts here. Used for testing when there is no hardware.
if (Simulate)
   {
   while (TRUE)
       {
       if (BuffersAcquired%2) {AcqBuf=AcqBuf1; ScalerBuf=ScalerBuf1;} else {AcqBuf=AcqBuf2; ScalerBuf=ScalerBuf2;} 
       BytesRecv=SimulateRead(AcqBuf,ScalerBuf); //g_print("BytesReceived=%d\n",BytesRecv);  
       BytesAcquired+=BytesRecv;
       ++BuffersAcquired; ++NewBufs;
       if (BuffersAcquired>1) pthread_cancel(Spec);         //Request cancellation of the Spec thread (if it is running)
       if (Setup.ListMode.ListOn)
          {
          if (Setup.ListMode.Compr==2) WriteRootBlock(AcqBuf,(int)(BytesRecv/2/NPar1),Setup.Parameter.NPar);      //ROOT
          else                         { if (!CompressToDisk(ListFp,AcqBuf)) break; }                //zls, csv, Freedom
          }
       if (BuffersAcquired>1) pthread_join(Spec,NULL);        //Make sure Spec is really killed before starting it again
       pthread_create(&Spec,NULL,BuildSpectra,(void *)AcqBuf);
       if (RefreshRate && (NewBufs>=RefreshRate))
          { UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf); NewBufs=0; Safety(RunName,&ElapsedTime,&SpecSaved); }
       else if (BuffersAcquired==1) UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
       if ((Setup.PLogSetup.On) && !(BuffersAcquired % Setup.PLogSetup.BufCount)) 
          PeriodicLog(1,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
       if (Setup.Macro.N && !(BuffersAcquired % Setup.Macro.RefreshRate)) ComputeMacros(BuffersAcquired,MacroFp);
       if (AcqSignal==Stop) break;
       }
   if (AcqSignal==Stop) UpdateDisplay(&ElapsedTime,TRUE,ScalerBuf);
   else  UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
   if (Setup.ListMode.ListOn) 
      {
      if (Setup.ListMode.Compr==0)                                                                  //Candle file format
         {
         CollectedEvents=BytesAcquired/2/Setup.Parameter.NPar;
         if (AcqSignal==Stop)                                                              //Stop for Candle format file
            {
            sprintf(NSC_txt,"STOP: %s ends. Collected %ld events",RunName,CollectedEvents); 
            queue_text(stop,NSC_txt,ListFp); writeEndOfFile(ListFp);
            }
         else                                                                             //Pause for Candle format file
            { 
            sprintf(NSC_txt,"PAUSED: %s paused. So far %ld events",RunName,CollectedEvents); 
            queue_text(pauseNSC,NSC_txt,ListFp); 
            }
         }
      if (Setup.ListMode.Compr==2) CloseRootFile(); else fclose(ListFp);
      }
   if (AcqSignal==Pause)
      for (i=0;i<Setup.Scaler.NSc;++i) ScalerPending[i]=ScalerCurr[i];           //Useful only if acquisition was paused
   if (AcqSignal==Stop)
      {
      PeriodicLog(2,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
                                                                                            //periodic.log final entries
      if (Setup.Macro.N) 
         { ComputeMacros(BuffersAcquired,MacroFp); if (Setup.Macro.N) fclose(MacroFp); }         //Finish macro log file
      for (i=0;i<Setup.Oned.N;i++) 
          { sprintf(FNam,"%s/Spec_%s/%s%03d.z1d",SpecDir,RunName,RunName,i+1); Write1d(FNam,i,1); }
      if (Setup.Twod.WSz==1) 
         for (i=0;i<Setup.Twod.N;++i) 
             { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d16(FNam,i,1); }
      else 
         for (i=0;i<Setup.Twod.N;++i) 
             { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d32(FNam,i,1); }
      }
   else PeriodicLog(3,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
   ProgramState=Free; pthread_exit(NULL);
   return NULL;
   }
//Simulation block ends here
else SAttention("LAMPS offline version cannot acquire data\nUse lamps -s for simulated acquisition");
ProgramState=Free; pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void OverwriteStart(GtkWidget *W,GtkWidget *Win)
{
gtk_widget_destroy(Win);
ProgramState=AcqOn;
if (!Setup.Spectra.NoZero) { ZeroOned(-1); ZeroTwod(-1); }
fstart_(RunName,strlen(RunName));                                                     //Call user initialisation routine
PauseDuration=0L;
strcpy(PrevRun,RunName); pthread_create(&Acq,NULL,AcquireData,NULL);
}
//----------------------------------------------------------------------------------------------------------------------
void StartCallBack(GtkWidget *W,GtkWidget *StartWin)
{
gint Overwrite,i;
gchar ListFName[2048],Str[2070],DName[2048];
GtkWidget *Win,*Label,*But;

gtk_widget_destroy(GTK_WIDGET(StartWin)); Overwrite=0;

sprintf(DName,"%s/Spec_%s",SpecDir,RunName);
for (i=0;i<Setup.Oned.N;i++) sprintf(Setup.Files.Oned[i],"%s/%s%03d.z1d",DName,RunName,i+1);
for (i=0;i<Setup.Twod.N;i++) sprintf(Setup.Files.Twod[i],"%s/%s%03d.z2d",DName,RunName,i+1);
if (Setup.ListMode.ListOn)
   {
   switch (Setup.ListMode.Compr)
      {
      case 0: sprintf(ListFName,"%s/%s.001",ListFDir,RunName); break;                  //IUAC Candle/Freedom file format
      case 1: sprintf(ListFName,"%s/%s.zls",ListFDir,RunName); break;    //Normal: The usual zls zero suppression scheme
      case 2: sprintf(ListFName,"%s/%s.root",ListFDir,RunName); break;                                            //ROOT
      case 3: sprintf(ListFName,"%s/%s.csv",ListFDir,RunName);                                               //Excel csv
      }
   if (!access(ListFName,F_OK)) Overwrite=1;
   }
else
   if (!access(DName,F_OK)) Overwrite=2;                                                      //Check existence of DName
mkdir(DName,0755);                                        //Create directory (if it already exists, nothing will happen)
if (Overwrite)
   {
   Win=gtk_dialog_new();
   g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));
   gtk_window_set_title(GTK_WINDOW(Win),"Overwrite?"); gtk_container_border_width(GTK_CONTAINER(Win),5);
   gtk_widget_set_uposition(GTK_WIDGET(Win),400,300);
   if (Overwrite==1) sprintf(Str,"Overwrite %s?",ListFName);
   else              sprintf(Str,"Prev. data exists. Overwrite Spec. Files?");
   Label=gtk_label_new(Str); gtk_misc_set_padding(GTK_MISC(Label),10,10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->vbox),Label,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_YES);
   g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(OverwriteStart),Win);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_CANCEL);
   g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   gtk_widget_show_all(Win);
   return;
   }
ProgramState=AcqOn;
if (!Setup.Spectra.NoZero) { ZeroOned(-1); ZeroTwod(-1); }
fstart_(RunName,strlen(RunName));                                                     //Call user initialisation routine
PauseDuration=0L;
strcpy(PrevRun,RunName); pthread_create(&Acq,NULL,AcquireData,NULL);
}
//----------------------------------------------------------------------------------------------------------------------
void CancelCallBack(GtkWidget *W,GtkWidget *StartWin)
{ gtk_widget_destroy(GTK_WIDGET(StartWin)); }
//----------------------------------------------------------------------------------------------------------------------
void StartWinDestroyed(GtkWidget *W,gpointer Unused)
{ ProgramState=Free; }
//----------------------------------------------------------------------------------------------------------------------
void RunNameCallBack(GtkWidget *W,gpointer Unused)
{ strcpy(RunName,gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void IncrementRunName()
{
gint i,RunNo,L,S;
gchar Str[120];

strcpy(RunName,PrevRun);
if (!strcmp(PrevRun,"Dummy")) return;
L=strlen(PrevRun);
for (i=L-1;i>0;i--) if (!isdigit(PrevRun[i])) break;
if ( (i==L-1) && (L<36) ) { RunName[L]='1'; RunName[L+1]='\0'; return; }
RunNo=atoi(&PrevRun[i+1])+1; sprintf(Str,"%d",RunNo); S=strlen(Str);
RunName[L-S]='\0'; strcat(RunName,Str);
}
//----------------------------------------------------------------------------------------------------------------------
void AutoStopCallBack(GtkWidget *W,gpointer Unused)
{ Setup.Hardware.AutoStop=atoi(gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void AutoStopToggle(GtkWidget *CheckBut,GtkWidget *Entry)
{
if (GTK_TOGGLE_BUTTON(CheckBut)->active) { Setup.Hardware.AutoStopOn=TRUE;  gtk_widget_set_sensitive(Entry,TRUE); }
                                    else { Setup.Hardware.AutoStopOn=FALSE; gtk_widget_set_sensitive(Entry,FALSE); }
}
//----------------------------------------------------------------------------------------------------------------------
void StartAcquisition(void)
{
gint i;
gchar Str[MAX_FNAME_LENGTH+20];
GtkWidget *Win,*VBox,*HBox,*Label,*But,*Entry,*CheckBut;
static GdkColor White = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor Black = {0,0x0000,0x0000,0x0000};
static GdkColor Gold  = {0,0xBBBB,0x9999,0x0000};
static GdkColor Blue  = {0,0x0000,0x0000,0xFFFF};
GtkStyle *RunStyle,*BlueStyle;

CreateDir();                                     //Create directories as per user preferences if they dont exist already
RunStyle=gtk_style_copy(gtk_widget_get_default_style());                              //Copy default style to this style
RunStyle->text[0]=White  /*Normal Text*/; RunStyle->text[3]=White /*Selected text*/;
RunStyle->fg[5]  =Black /*Box boundary*/; RunStyle->text[5]=Gold       /*Box fill*/;
BlueStyle=gtk_style_copy(gtk_widget_get_default_style());                             //Copy default style to this style
for (i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=Blue; BlueStyle->bg[i]=White; }     //Set colours for all states

ProgramState=AcqOn; IncrementRunName();
Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(StartWinDestroyed),NULL);
gtk_window_set_title(GTK_WINDOW(Win),"Start Acquisition"); gtk_widget_set_uposition(GTK_WIDGET(Win),300,300);
gtk_container_set_border_width(GTK_CONTAINER(Win),10);
VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox);                     //VBox for the entire window

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Prev. Run:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
sprintf(Str,"%s",PrevRun); Label=gtk_label_new(Str); SetStyleRecursively(Label,BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Run Name:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
Entry=gtk_entry_new_with_max_length(35); gtk_box_pack_start(GTK_BOX(HBox),Entry,FALSE,FALSE,0);
SetStyleRecursively(Entry,RunStyle);
gtk_entry_set_text(GTK_ENTRY(Entry),RunName);
gtk_widget_set_usize(GTK_WIDGET(Entry),130,25);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(RunNameCallBack),NULL);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Setup File:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
AbbreviateFileName(Str,Setup.FName,MAX_FNAME_LENGTH);
if (Setup.Modified) strcat(Str,"(?)");
if (!strlen(Setup.FName)) sprintf(Str,"%s","none");
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
CheckBut=gtk_check_button_new_with_label("Auto Stop");
gtk_box_pack_start(GTK_BOX(HBox),CheckBut,FALSE,FALSE,0);
GTK_TOGGLE_BUTTON(CheckBut)->active=Setup.Hardware.AutoStopOn;
Entry=gtk_entry_new_with_max_length(10); gtk_box_pack_start(GTK_BOX(HBox),Entry,FALSE,FALSE,0);
sprintf(Str,"%d",Setup.Hardware.AutoStop); gtk_entry_set_text(GTK_ENTRY(Entry),Str);
gtk_widget_set_usize(GTK_WIDGET(Entry),50,25);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(AutoStopCallBack),NULL);
Label=gtk_label_new("sec"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
if (Setup.Hardware.AutoStopOn) gtk_widget_set_sensitive(Entry,TRUE); else gtk_widget_set_sensitive(Entry,FALSE);
g_signal_connect(GTK_OBJECT(CheckBut),"toggled",G_CALLBACK(AutoStopToggle),Entry);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
But=gtk_button_new_from_stock(GTK_STOCK_YES);
gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,5);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StartCallBack),GTK_OBJECT(Win));
But=gtk_button_new_from_stock(GTK_STOCK_CANCEL);
gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,5);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(CancelCallBack),GTK_OBJECT(Win));

gtk_widget_show_all(Win);
gtk_style_unref(RunStyle); gtk_style_unref(BlueStyle);
}
//----------------------------------------------------------------------------------------------------------------------
void StartNoZero(GtkWidget *W,gpointer Data)
{
if ( (ProgramState==AnalysisOn) || (ProgramState==ReWriteOn) )
   { Attention(0,"Sorry...Another task is in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition in progress"); return; }
if (AcqSignal == Resume) { Attention(0,"Acquisition already in progress"); return; }
if (AcqSignal == Pause)  { Attention(0,"Acquisition is Paused. Click Resume."); return; }
Setup.Spectra.NoZero=TRUE;
StartAcquisition();
}
//----------------------------------------------------------------------------------------------------------------------
void StartNormal(GtkWidget *W,gpointer Data)
{
if ( (ProgramState==AnalysisOn) || (ProgramState==ReWriteOn) )
   { Attention(0,"Sorry...Another task is in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted during batch acquisition"); return; }
if (AcqSignal == Resume) { Attention(0,"Acquisition already in progress"); return; }
if (AcqSignal == Pause)  { Attention(0,"Acquisition is Paused. Click Resume."); return; }
Setup.Spectra.NoZero=FALSE;
StartAcquisition();
}
//----------------------------------------------------------------------------------------------------------------------
void PauseAcquisition(GtkWidget *W,gpointer Data)
{
}
//----------------------------------------------------------------------------------------------------------------------
void ResumeAcquisition(GtkWidget *W,gpointer Data)
{
}
//----------------------------------------------------------------------------------------------------------------------
void StopNicely(void)
{
AcqSignal=Stop;
fstop_();                                                   //Execute user written code everytime acquisition is stopped
}
//----------------------------------------------------------------------------------------------------------------------
void StopAcquisition(GtkWidget *W,gpointer Data)
{
if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition running"); return; }
if (AcqSignal == Stop) { Attention(0,"Acquisition is not running"); return; }
if (AcqSignal == Pause) { Attention(0,"Please resume acquisition first"); return; }
AcqSignal=Stop;
SendStopAcq();
fstop_();                                                   //Execute user written code everytime acquisition is stopped
}
//----------------------------------------------------------------------------------------------------------------------
void RemoveInitialBlanks(gchar *Str)
{
gint i;
gchar Str2[100];

for (i=0;i<strlen(Str);i++) if (Str[i] != ' ') break;
strcpy(Str2,&Str[i]); strcpy(Str,Str2);
}
//----------------------------------------------------------------------------------------------------------------------
gint GetNaf(gchar *Str)
{
gint N,A,F;
gchar TStr[100];

Str=index(Str,(gint)':'); strcpy(TStr,&Str[1]); RemoveInitialBlanks(TStr); N=atoi(TStr);
Str=index(TStr,(gint)' '); RemoveInitialBlanks(Str); A=atoi(Str);
Str=index(Str,(gint)' '); RemoveInitialBlanks(Str); F=atoi(Str);
return (N<<9)+(A<<5)+F;
}
//----------------------------------------------------------------------------------------------------------------------
gushort GetVal(gchar *Str)
{
Str=index(Str,(gint)'='); return (gushort)atoi(&Str[1]);
}
//----------------------------------------------------------------------------------------------------------------------

