#include <gtk/gtk.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include "lamps.h"

//External Globals
extern enum ProgramState ProgramState;
extern struct Setup Setup;
extern struct PsBGated PsBGated[MAX_PSEUDO];                                                  //Banana gated pseudo type
extern guint16 *Oned16,*Twod16;
extern guint32 *Oned32,*Twod32,*Proj;
extern gint Off1d[MAX_1D],Off2d[MAX_2D],OffProj[MAX_2D];
extern gint ScreenSpecNo[SCREEN_TOT][MAX_SCREENS],ScreenSpecType[SCREEN_TOT][MAX_SCREENS];
extern struct WinProperties Prop[SCREEN_TOT];
extern gchar SetupDir[MAX_DIR_STRLEN];                                                                 //Directory prefs
extern gint MainX;
extern gint MonXRes,MonYRes,TopSpace,BotSpace,XBorder,YBorder,CanvasMinW,CanvasMinH,TopOfset;

//Globals in this file only
GtkWidget *ParaListW;
gboolean ParaListVisible=FALSE;

//Function Templates
void ParaError(gint Stn); void SubAddrError(gint Stn); void NameError(gint Stn);
void ParsePar(gint Stn,gchar *LoPar,gchar *HiPar,gint NoHi,gint *LoP,gint *HiP);
void ParseSub(gint Stn,gchar *LoSub,gchar *HiSub,gint NoHiA,gint LoP,gint HiP);
void CheckSetup(void); void ParameterSetup(void); 
void ParameterList(GtkWidget *W,gpointer Data); void ListModeSettings(GtkWidget *W,gpointer Data);
void OnedSpecSettings(GtkWidget *W,gpointer Data); 
void TwodSpecSettings(GtkWidget *W,gpointer Data); 
void PseudoSettings(GtkWidget *W,gpointer Data);
void ScalerSettings(GtkWidget *W,gpointer Data);
void AllocateMemory(void);
void AllocateScreenWins(void); void Test1dMem16(void); void Test1dMem32(void);
void Attention(gint XPos,gchar *Messg);
void CloseAllSpecWindows(GtkWidget *W,gpointer Unused);
void FindBounds(gint *U,gint N,gint *Lo,gint *Hi);
gboolean ReadBananaFile(gchar *FName,struct BGate *BGate);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
void Save(gint Opt);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
//----------------------------------------------------------------------------------------------------------------------
void Test1dMem16(void)
{
gint i,j,k;

g_print("Testing 1d Mem 16-bit\n");
for (i=0;i<Setup.Oned.N;++i)
    {
    g_print("Testing Spec# %d Offset=%d\n",i,Off1d[i]);
    for (j=0;j<Setup.Oned.Chan[i];j++)
        {
        k=Off1d[i]+j; Oned16[k]=k; 
        if (!(k%500)) g_print("Oned16[%d]=%d\n",k,Oned16[k]);
        }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void Test1dMem32(void)
{
gint i,j,k;

g_print("Testing 1d Mem 32-bit\n");
for (i=0;i<Setup.Oned.N;++i)
    {
    g_print("Testing Spec# %d Offset=%d\n",i,Off1d[i]);
    for (j=0;j<Setup.Oned.Chan[i];j++)
        {
        k=Off1d[i]+j; Oned32[k]=k; 
        if (!(k%500)) g_print("Oned32[%d]=%d\n",k,Oned32[k]);
        }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void AllocateMemory(void)                                   //Allocate memory for 1d and 2d spectra
{
gint i;
size_t Mem1,Mem2,MemProj;

for (i=0,Mem1=0;i<Setup.Oned.N;++i) Mem1+=Setup.Oned.Chan[i];
for (i=0,Mem2=0;i<Setup.Twod.N;++i) Mem2+=Setup.Twod.XChan[i]*Setup.Twod.YChan[i];
if (Setup.Twod.WSz*Mem2 == G_MAXLONG) { Attention(0,"Memory size for 2D exceeded!"); ProgramState=Invalid; return; }
if (Setup.Oned.WSz == 1)
   {
   Oned32=g_renew(guint32,Oned32,0);                               //Free memory for 32-bit spectra
   Oned16=g_renew(guint16,Oned16,Mem1);
   if (Setup.Oned.N && (Oned16 == NULL)) 
      { Attention(0,"Not enough memory for 1d Spectra"); ProgramState=Invalid; }
   }
else
   {
   Oned16=g_renew(guint16,Oned16,0);                              //Free memory for 16-bit spectra
   Oned32=g_renew(guint32,Oned32,Mem1);
   if (Setup.Oned.N && (Oned32 == NULL))
      { Attention(0,"Not enough memory for 1d Spectra"); ProgramState=Invalid; }
   }
Off1d[0]=0; for (i=1;i<Setup.Oned.N;++i) Off1d[i]=Off1d[i-1]+Setup.Oned.Chan[i-1];
if (Setup.Twod.WSz == 1)
   {
   Twod32=g_renew(guint32,Twod32,0);                               //Free memory for 32-bit spectra
   Twod16=g_renew(guint16,Twod16,Mem2);
   if (Setup.Twod.N && (Twod16 == NULL)) 
      { Attention(0,"Not enough memory for 2d Spectra"); ProgramState=Invalid; }
   }
else
   {
   Twod16=g_renew(guint16,Twod16,0);                               //Free memory for 16-bit spectra
   Twod32=g_renew(guint32,Twod32,Mem2);
   if (Setup.Twod.N && (Twod32 == NULL)) 
      { Attention(0,"Not enough memory for 2d Spectra"); ProgramState=Invalid; }
   }
Off2d[0]=0; 
for (i=1;i<Setup.Twod.N;++i) Off2d[i]=Off2d[i-1]+Setup.Twod.XChan[i-1]*Setup.Twod.YChan[i-1];

/* Allocate memory for X and Y projections */
for (i=0,MemProj=0;i<Setup.Twod.N;++i) MemProj+=MAX(Setup.Twod.XChan[i],Setup.Twod.YChan[i]);

Proj=g_renew(guint32,Proj,MemProj);
if (Setup.Twod.N && (Proj == NULL)) 
   { Attention(0,"Not enough memory for projections"); ProgramState=Invalid; }
OffProj[0]=0; 
for (i=1;i<Setup.Twod.N;++i) 
    OffProj[i]=OffProj[i-1]+MAX(Setup.Twod.XChan[i-1],Setup.Twod.YChan[i-1]);

//if (Setup.Oned.WSz == 1) Test1dMem16(); else Test1dMem32();
/*
g_print("----------------AllocateMemory------------------------\n");
g_print("# of 1d spectra=%d WordSize=%d Mem1=%ld\n",Setup.Oned.N,Setup.Oned.WSz,Mem1);
for (i=0;i<Setup.Oned.N;++i) g_print("%d %d %d\n",i+1,Setup.Oned.Par[i],Setup.Oned.Chan[i]);
g_print("# of 2d spectra=%d WordSize=%d Mem2=%ld\n",Setup.Twod.N,Setup.Twod.WSz,Mem2);
for (i=0;i<Setup.Twod.N;++i) g_print("%d %d %d %d %d\n",i+1,Setup.Twod.XPar[i],Setup.Twod.YPar[i],Setup.Twod.XChan[i],Setup.Twod.YChan[i]);
g_print("------------------------------------------------------\n");
*/
}
//----------------------------------------------------------------------------------------------------------------------
gint Msb(guint N)                          //Find the position of the most significan bit of N (namely log(N) to base 2)
{
gint i;

//g_print("N=%d \n",N);
for (i=0;i<17;++i) { N>>=1; if (!N) {/*g_print("i=%d \n",i);*/ return i; } }            //It will work only upto 16 bits
return 0;
}
//----------------------------------------------------------------------------------------------------------------------
void CalculateBitShifts()                                     //The bit shifts required while building 1d and 2d spectra
{
gint i,j;
gchar Str[120];
gboolean ErrMes;

for (i=0,ErrMes=FALSE;i<Setup.Oned.N;++i)
    {
//g_print("Msb(Setup.Parameter.Chan[Setup.Oned.Par[i]-1])=%d,Msb(Setup.Oned.Chan[i])=%d \n",Msb(Setup.Parameter.Chan[Setup.Oned.Par[i]-1]),Msb(Setup.Oned.Chan[i]));
//g_print("Setup.Oned.Chan[i]=%d, Setup.Parameter.Chan[Setup.Oned.Par[i]]=%d \n",Setup.Oned.Chan[i], Setup.Parameter.Chan[Setup.Oned.Par[i]]);

    if (Setup.Oned.Par[i]>0)
    {
    Setup.Oned.BitShift[i]=Msb(Setup.Parameter.Chan[Setup.Oned.Par[i]-1])-Msb(Setup.Oned.Chan[i]);
    //g_print("i=%d, Setup.Oned.BitShift[i]=%d \n",i,Setup.Oned.BitShift[i]);
    }
    else if (Setup.Oned.NPar[i]>1) { sprintf(Str,"1d Spec %d Vector spectrum\nPara=0 illegal!",i+1); Attention(-100,Str); }
    if (Setup.Oned.NPar[i]>1)                                     //Multi-update 1d vector spectrum
       for (j=1;j<Setup.Oned.NPar[i];++j)
           {
           if ((Setup.Parameter.Chan[Setup.Oned.Par[i]-1+j]!=Setup.Parameter.Chan[Setup.Oned.Par[i]-1]) && !ErrMes)
              { ErrMes=TRUE; sprintf(Str,"1d Spec %d Vector spectrum\nDiffering para size illegal!",i+1); Attention(100,Str); }
           }
    }
for (i=0,ErrMes=FALSE;i<Setup.Twod.N;++i)
    {
    Setup.Twod.XBitShift[i]=Msb(Setup.Parameter.Chan[Setup.Twod.XPar[i]-1])-Msb(Setup.Twod.XChan[i]);
    if (Setup.Twod.NXPar[i]>1)                                                    //Multi-update 2d spectrum, vector X-Axis 
       for (j=1;j<Setup.Twod.NXPar[i];++j)
           {
           if ((Setup.Parameter.Chan[Setup.Twod.XPar[i]-1+j]!=Setup.Parameter.Chan[Setup.Twod.XPar[i]-1]) && !ErrMes)
              { ErrMes=TRUE; sprintf(Str,"2d Spec %d Vector X-axis\nDiffering para size illegal!",i+1); Attention(-100,Str); }
           }
    Setup.Twod.YBitShift[i]=Msb(Setup.Parameter.Chan[Setup.Twod.YPar[i]-1])-Msb(Setup.Twod.YChan[i]);
    if (Setup.Twod.NYPar[i]>1)                                                    //Multi-update 2d spectrum, vector Y-Axis 
       for (j=1;j<Setup.Twod.NYPar[i];++j)
           {
           if ((Setup.Parameter.Chan[Setup.Twod.YPar[i]-1+j]!=Setup.Parameter.Chan[Setup.Twod.YPar[i]-1]) && !ErrMes)
              { ErrMes=TRUE; sprintf(Str,"2d Spec %d Vector Y-axis\nDiffering para size illegal!",i+1); Attention(100,Str); }
           }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void AllocateScreenWins(void)  
/*First allocate all the 1D spectra then all the 2D spectra*/
{
gint i,j,Win,Screen;

/* First we initialise ScreenSpecNo and ScreenSpecType. 
 * Note: ScreenSpecType=0 for no spectrum, =1 for 1d spectrum, =2 for 2d spectrum, 
         =3 for XProj, =4 for YProj*/
for (Screen=0;Screen<MAX_SCREENS;Screen++) 
for (Win=0;Win<SCREEN_TOT;Win++) ScreenSpecNo[Win][Screen]=ScreenSpecType[Win][Screen]=0;
j=0;
for (i=0;i<Setup.Oned.N;++i)
    {
    Screen=j/SCREEN_TOT;  Win=j%SCREEN_TOT;
    ScreenSpecNo[Win][Screen]=i; ScreenSpecType[Win][Screen]=1;
    j++;
    }
for (i=0;i<Setup.Twod.N;++i)
    {
    Screen=j/SCREEN_TOT; Win=j%SCREEN_TOT;
    ScreenSpecNo[Win][Screen]=i; ScreenSpecType[Win][Screen]=2;
    j++;
    }
CloseAllSpecWindows(NULL,NULL);                            //If any windows are open, we close them
for (i=0;i<SCREEN_TOT;++i)                                 //Initial properties for all the windows
    { 
    Prop[i].Open=0; Prop[i].InUse=0;                               //Closed, not locked by activity
    for (j=0;j<MAX_OVERLAP;j++)                           //Initialise variables related to overlap
        { 
        Prop[i].One.OvSpec[j]=0; Prop[i].One.OvHShift[j]=0; 
        Prop[i].One.OvVShift[j]=1; Prop[i].One.Overlap[j]=FALSE; 
        }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void CheckPseudos(void)
{
gint i,j;
gchar Str[256];

for (i=0;i<Setup.Pseudo.N;++i)
    {
    for (j=0;j<MAX_TEXT_FIELD;++j) 
        if (Setup.Pseudo.Name[i][j]==' ') Setup.Pseudo.Name[i][j]='_';      //Replace blanks by _
    Setup.Pseudo.P1[i]=CLAMP(Setup.Pseudo.P1[i],1,Setup.Parameter.NPar+Setup.Pseudo.N);
    Setup.Pseudo.P2[i]=CLAMP(Setup.Pseudo.P2[i],1,Setup.Parameter.NPar+Setup.Pseudo.N);
    if (Setup.Pseudo.Type[i]==Multiplicity) 
       { 
       Setup.Pseudo.L1[i]=CLAMP(Setup.Pseudo.L1[i],1,Setup.Parameter.NPar+Setup.Pseudo.N);
       Setup.Pseudo.L2[i]=CLAMP(Setup.Pseudo.L2[i],1,Setup.Parameter.NPar+Setup.Pseudo.N);
       }
    if (Setup.Pseudo.Type[i]==BGated)
       {
       if (!ReadBananaFile(PsBGated[i].Name,&PsBGated[i].BGate))
          {
          sprintf(Str,"Pseudo Para #%d invalid banana file\n%s",i+1,PsBGated[i].Name);
          Attention(-200+8*i,Str);
          }
       }
    Setup.Parameter.Chan[Setup.Parameter.NPar+i]=Setup.Pseudo.Size[i];
    }
}
//----------------------------------------------------------------------------------------------------------------------
gboolean ReadBananaFile(gchar *FName,struct BGate *BGate)
{
FILE *Fp;
gchar Str[MAX_FNAME_LENGTH+80];
gint i,j;

if ((Fp=fopen(FName,"r")) == NULL) return FALSE;
for (i=0;i<MAX_BAN_POINTS;++i) BGate->X[i]=BGate->Y[i]=0;
fgets(Str,120,Fp);                                                               //Skip title line
fscanf(Fp,"%s %d",Str,&(BGate->XPar)); fscanf(Fp,"%s %d",Str,&(BGate->YPar)); 
fscanf(Fp,"%s %d",Str,&(BGate->N));
for (i=0;i<BGate->N;++i) fscanf(Fp,"%s %d %d %d",Str,&j,&(BGate->X[i]),&(BGate->Y[i]));
fclose(Fp);

BGate->XPar=CLAMP(BGate->XPar,1,MAX_PAR); BGate->YPar=CLAMP(BGate->YPar,1,MAX_PAR);
BGate->N=CLAMP(BGate->N,3,MAX_BAN_POINTS);
FindBounds(BGate->X,BGate->N,&(BGate->XMin),&(BGate->XMax));
FindBounds(BGate->Y,BGate->N,&(BGate->YMin),&(BGate->YMax));
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
void CheckOned(void)                             //Clamp Oned sizes, read and validate banana files
{
gint SNo,Gate,j;
gboolean Suppress;
gchar ShortName[25],Messg[120];

for (SNo=0,Suppress=FALSE;SNo<Setup.Oned.N;++SNo)
    {
    for (j=0;j<MAX_TEXT_FIELD;++j) 
        if (Setup.Oned.Name[SNo][j]==' ') Setup.Oned.Name[SNo][j]='_';                              //Replace blanks by _
    Setup.Oned.Par[SNo]=CLAMP(Setup.Oned.Par[SNo],0,Setup.Parameter.NPar+Setup.Pseudo.N);          //Par=0 is hit pattern
    if (Setup.Oned.Par[SNo]>0)
       {
       Setup.Oned.Chan[SNo]=CLAMP(Setup.Oned.Chan[SNo],16,Setup.Parameter.Chan[Setup.Oned.Par[SNo]-1]);
       //g_print("Setup.Parameter.Chan[Setup.Oned.Par[SNo]-1]=%d \n",Setup.Parameter.Chan[Setup.Oned.Par[SNo]-1]);
       }
    else Setup.Oned.Chan[SNo]=CLAMP(Setup.Oned.Chan[SNo],16,1024);
    for (Gate=0;Gate<Setup.Oned.Gate2[SNo].NGates;++Gate)
        {
        if (!ReadBananaFile(Setup.Oned.Gate2[SNo].Gate2d[Gate],&Setup.Oned.Gate2[SNo].BGates[Gate])) 
           {
           if (!Suppress) 
              {
              AbbreviateFileName(ShortName,Setup.Oned.Gate2[SNo].Gate2d[Gate],18);
              sprintf(Messg,"1dSpec #%d Gate #%d failed:\n%s\nFurther messages suppressed",SNo,Gate,ShortName);
              Attention(-200,Messg);
              }
           Suppress=TRUE;
           }
        }
    }
}
//----------------------------------------------------------------------------------------------------------------------
gboolean CheckDCO(gint SNo)                                          //Radware .spn matrices must be 4K x 4K x Double Word
{
gint i,j,XPar,YPar;

if (Setup.Twod.XChan[SNo]!=4096)                  return FALSE; 
if (Setup.Twod.YChan[SNo]!=4096)                  return FALSE;
if (Setup.Twod.WSz!=2)                            return FALSE;

for (i=0;i<Setup.Twod.NXPar[SNo];++i)                                 //For DCO matrices, X and Y vectors must not overlap
    {
    XPar=Setup.Twod.XPar[SNo]+i-1;
    for (j=0;j<Setup.Twod.NYPar[SNo];++j)
        {
        YPar=Setup.Twod.YPar[SNo]+j-1;
        if (XPar==YPar) return FALSE;
        }
    }
Setup.Twod.MatrixType[SNo]=DCO; return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
gboolean CheckGammaGamma(gint SNo)                                   //Radware .spn matrices must be 4K x 4K x Double Word
{
if (Setup.Twod.NXPar[SNo]!=Setup.Twod.NYPar[SNo]) return FALSE;//For GammaGamma matrices, X and Y vectors must be the same
if (Setup.Twod.XPar[SNo]!=Setup.Twod.YPar[SNo])   return FALSE;
if (Setup.Twod.XChan[SNo]!=4096)                  return FALSE;
if (Setup.Twod.YChan[SNo]!=4096)                  return FALSE;
if (Setup.Twod.WSz!=2)                            return FALSE;
Setup.Twod.MatrixType[SNo]=GammaGamma; return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
void CheckTwod(void)                                                    //Clamp Twod sizes, read and validate banana files
{
gint SNo,Gate,j;
gboolean Suppress;
gchar ShortName[25],Messg[120];

for (SNo=0,Suppress=FALSE;SNo<Setup.Twod.N;++SNo)
    {
    for (j=0;j<MAX_TEXT_FIELD;++j) 
        if (Setup.Twod.Name[SNo][j]==' ') Setup.Twod.Name[SNo][j]='_';                              //Replace blanks by _
    Setup.Twod.XPar[SNo]=CLAMP(Setup.Twod.XPar[SNo],0,Setup.Parameter.NPar+Setup.Pseudo.N);        //Par=0 is hit pattern
    Setup.Twod.YPar[SNo]=CLAMP(Setup.Twod.YPar[SNo],0,Setup.Parameter.NPar+Setup.Pseudo.N);        //Par=0 is hit pattern
    Setup.Twod.XChan[SNo]=CLAMP(Setup.Twod.XChan[SNo],16,Setup.Parameter.Chan[Setup.Twod.XPar[SNo]-1]);
    Setup.Twod.YChan[SNo]=CLAMP(Setup.Twod.YChan[SNo],16,Setup.Parameter.Chan[Setup.Twod.YPar[SNo]-1]);
    Setup.Twod.MatrixType[SNo]=Other;
    if (Setup.Twod.NXPar[SNo]>1 || Setup.Twod.NYPar[SNo]>1)                              //Check GammaGamma, DCO or Other
       {
       if (CheckGammaGamma(SNo)) sprintf(Messg,"2dSpec #%d Gamma-Gamma Matrix will be saved as RADWARE .spn",SNo+1);
       else if (CheckDCO(SNo))   sprintf(Messg,"2dSpec #%d DCO Matrix will be saved as RADWARE .spn",SNo+1);
       else                      sprintf(Messg,"2dSpec #%d not a standard Gamma-Gamma or DCO Matrix\nFor Radware spn you need 4kx4k Double Word",SNo+1);
       Attention(50*SNo,Messg);
       }
    for (Gate=0;Gate<Setup.Twod.Gate2[SNo].NGates;++Gate)
        {
        if (!ReadBananaFile(Setup.Twod.Gate2[SNo].Gate2d[Gate],&Setup.Twod.Gate2[SNo].BGates[Gate]))
           {
           if (!Suppress)
              {
              AbbreviateFileName(ShortName,Setup.Twod.Gate2[SNo].Gate2d[Gate],18);
              sprintf(Messg,"2dSpec #%d Gate #%d failed:\n%s\nFurther messages suppressed",SNo,Gate,ShortName);
              Attention(200,Messg);
              }
           Suppress=TRUE;
           }
        }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void CheckScaler()
{
gint i,j;

Setup.Scaler.Master=-1;
for (i=0;i<Setup.Scaler.NSc;++i) 
    { 
    Setup.Scaler.C[i]=CLAMP(Setup.Scaler.C[i],1,2);
    for (j=0;j<MAX_TEXT_FIELD;++j) 
        if (Setup.Scaler.Name[i][j]==' ') Setup.Scaler.Name[i][j]='_'; }        //Replace blanks _
for (i=0;i<Setup.Scaler.NSc;++i)
    if (!strncasecmp(Setup.Scaler.Name[i],"master",5)) { Setup.Scaler.Master=i; break; }
if (Setup.Hardware.NCrates==1) Setup.Scaler.NSc1=Setup.Scaler.NSc;
   else Setup.Scaler.NSc1=CLAMP(Setup.Scaler.NSc1,0,Setup.Scaler.NSc);
}
//----------------------------------------------------------------------------------------------------------------------
void CheckPLog()
{ Setup.PLogSetup.BufCount=CLAMP(Setup.PLogSetup.BufCount,1,8192); }
//----------------------------------------------------------------------------------------------------------------------
void CheckMacros()
{
gint i;

Setup.Macro.N=CLAMP(Setup.Macro.N,0,MAX_MACRO);
Setup.Macro.RefreshRate=CLAMP(Setup.Macro.RefreshRate,1,8192);
for (i=0;i<MAX_MACRO;++i)
    {
    Setup.Macro.Type[i]=CLAMP(Setup.Macro.Type[i],0,9);
    if ( (Setup.Macro.Type[i]==MacroArea) || (Setup.Macro.Type[i]==MacroIntegral) )
       {
       Setup.Macro.SpecNo[i]=CLAMP(Setup.Macro.SpecNo[i],1,Setup.Oned.N);
       Setup.Macro.XMin[i]=CLAMP(Setup.Macro.XMin[i],0,Setup.Oned.Chan[Setup.Macro.SpecNo[i]-1]-2);
       Setup.Macro.XMax[i]=CLAMP(Setup.Macro.XMax[i],Setup.Macro.XMin[i]+1,Setup.Oned.Chan[Setup.Macro.SpecNo[i]-1]-1);
       }
    if ( (Setup.Macro.Type[i]==MacroRectangle) || (Setup.Macro.Type[i]==MacroBanana) )
       {
       Setup.Macro.SpecNo[i]=CLAMP(Setup.Macro.SpecNo[i],1,Setup.Twod.N);
       Setup.Macro.XMin[i]=CLAMP(Setup.Macro.XMin[i],0,Setup.Twod.XChan[Setup.Macro.SpecNo[i]-1]-2);
       Setup.Macro.XMax[i]=CLAMP(Setup.Macro.XMax[i],Setup.Macro.XMin[i]+1,Setup.Twod.XChan[Setup.Macro.SpecNo[i]-1]-1);
       Setup.Macro.YMin[i]=CLAMP(Setup.Macro.YMin[i],0,Setup.Twod.YChan[Setup.Macro.SpecNo[i]-1]-2);
       Setup.Macro.YMax[i]=CLAMP(Setup.Macro.YMax[i],Setup.Macro.YMin[i]+1,Setup.Twod.YChan[Setup.Macro.SpecNo[i]-1]-1);
       }
    if (Setup.Macro.N)
       {
       if (Setup.Scaler.NSc) Setup.Macro.ScalerNo[i]=CLAMP(Setup.Macro.ScalerNo[i],1,Setup.Scaler.NSc);
       Setup.Macro.Index1[i]=CLAMP(Setup.Macro.Index1[i],1,Setup.Macro.N);
       Setup.Macro.Index2[i]=CLAMP(Setup.Macro.Index2[i],1,Setup.Macro.N);
       }
    }
}
//----------------------------------------------------------------------------------------------------------------------
void CheckSetup(void)                           
//Go through the values of setup parameters in memory and make corrections, report errors
{
if (!Setup.Parameter.IgnoreCamac)
   {
   ParameterSetup();                                              //Go through Hardware Setup and create Parameter Setup
   }
CheckPseudos();                                                                        //Clamp parameters in pseudo setup
CheckMacros();                                                                          //Clamp parameters in macro setup
CalculateBitShifts();                                            //The bit shifts required for building 1d and 2d spectra
CheckOned();
CheckTwod();
CheckScaler();                                                                       //Locate the scaler labelled Masters
CheckPLog();                                                        //Check settings for the periodic log saftety feature
AllocateMemory();                                                                 //Allocate memory for 1d and 2d spectra
AllocateScreenWins();                                                         //Assign spectra to windows for each screen
ParameterList(NULL,NULL);
Save(1);                                           //Setup file saved to .lamps_set so that lamps can read it on re-start
}
//----------------------------------------------------------------------------------------------------------------------
void ParaError(gint Stn)
{ 
gchar Str[1024];

ProgramState=Invalid;
sprintf(Str,"Error in Hardware Setup Stn No %d\nPara=%s\nThe setup is now invalid",
        Stn+1,Setup.Hardware.Paras[Stn]);
Attention(0,Str);
}
//----------------------------------------------------------------------------------------------------------------------
void SubAddrError(gint Stn)
{ 
gchar Str[1024];

ProgramState=Invalid;
sprintf(Str,"Error in Hardware Setup Stn No %d\nSubAddr=%s\nThe Setup is now invalid",
        Stn+1,Setup.Hardware.SubAddr[Stn]);
Attention(0,Str);
}
//----------------------------------------------------------------------------------------------------------------------
void NameError(gint Stn)
{ 
gchar Str[XLONG_TEXT_FIELD+100];

ProgramState=Invalid;
sprintf(Str,"Error in Hardware Setup Stn No %2d\nName=%s\nThe Setup is now invalid",
        Stn+1,Setup.Hardware.ParaNames[Stn]);
Attention(0,Str);
}
//----------------------------------------------------------------------------------------------------------------------
gint ValidateAdcGain(gint Gain)                                                    //Makes sure the gain is a power of 2
{
gint i,Val;

Gain=CLAMP(Gain,16,65536);                                      //Dont expect less than 16 and of course cant exceed 64K
for (i=0,Val=1;i<17;++i) { Gain>>=1; if (!Gain) return Val; Val<<=1; }
return 8192;                                                                               //Code doesnt ever reach here
}
//----------------------------------------------------------------------------------------------------------------------
void ParsePar(gint Stn,gchar *LoPar,gchar *HiPar,gint NoHi,gint *LoP,gint *HiP)
{
gint i;

*LoP=CLAMP(atoi(LoPar),1,MAX_PAR);
if (!NoHi) *HiP=CLAMP(atoi(HiPar),1,MAX_PAR); else *HiP=*LoP;
Setup.Parameter.NPar=0;
for (i=*LoP-1;i<=*HiP-1;++i)
    {
    Setup.Parameter.NPar=MAX(i+1,Setup.Parameter.NPar);
    Setup.Parameter.N[i]=Stn+1;
    Setup.Parameter.Chan[i]=ValidateAdcGain(Setup.Hardware.Properties[Stn].AdcGain); 
    Setup.Parameter.LLD[i]=CLAMP(Setup.Hardware.ZSupLLD[Stn],1,Setup.Parameter.Chan[i]-1); 
    Setup.Parameter.ULD[i]=CLAMP(Setup.Hardware.ZSupULD[Stn],1,Setup.Parameter.Chan[i]-1);
    }
}
//----------------------------------------------------------------------------------------------------------------------
void ParseSub(gint Stn,gchar *LoSub,gchar *HiSub,gint NoHiA,gint LoP,gint HiP)
{
int i,LoA,A;

/*Notice that HiSub is not required at all!*/
LoA=CLAMP(atoi(LoSub),0,63);                                          //Allowing A values upto 64
for (i=LoP-1,A=LoA;i<=HiP-1;++i,A++) Setup.Parameter.A[i]=A;
}
//----------------------------------------------------------------------------------------------------------------------
void ParseName(gchar *Str,gchar *Name,gint *N)                                      //Disects Str into a name and number
//E.g. if Str is Energy05 Then Name will be Energy and N will be 5.
//If Str is purely numeric we set Name to NULL
//If Str is purely alpha-numeric we return *N=1 (rather than *N=0)
{
gint i,stringlen;
gchar strdigit[XLONG_TEXT_FIELD]="\0";

*N=1;
stringlen=strlen(Str);
i=stringlen;
do
  {
  if (!(isdigit((gint)Str[i-1]))) 
     {
     strncpy(strdigit,&Str[i],stringlen-i); strdigit[stringlen]='\0';
     *N=atoi(strdigit); 
     break ;
     }
  i--;
  } while (i);
if (i>0) { strncpy(Name,Str,i); Name[i]='\0'; } else {Name[0]='\0'; *N=atoi(Str);}
//g_print("N=%d, Name=%s \n",*N,Name);
}
//----------------------------------------------------------------------------------------------------------------------
void Tokenize(gchar *Str,gchar Delim,gint *N,gchar Token[MAX_TOKENS][XLONG_TEXT_FIELD])
{
int i,j;

*N=0;
for (i=0,j=0;i<=strlen(Str);++i)
   {
   if ((Str[i]==Delim) || (Str[i]=='\0'))
      {
      strncpy(Token[*N],&Str[j],i-j); Token[*N][i-j]='\0';
      (*N)++; j=i+1;
      }
   } 
}
//----------------------------------------------------------------------------------------------------------------------
void GraspParameterNames(void)                                                                 //Code added 21 July 2014
{
gint Stn,LoPar,HiPar,H1,H2,NTokens,i,Np,j,ParNo,NFirst,NLast,StringLen;
gchar *Ptr,Token[MAX_TOKENS][XLONG_TEXT_FIELD],Broken[MAX_TOKENS][XLONG_TEXT_FIELD],
      Alpha[MAX_TEXT_FIELD];

for (Stn=0;Stn<Setup.Hardware.NCrates*MAX_VME_STNS;++Stn)
   {
   //Obtain LoPar,HiPar from Setup.Hardware.Paras[Stn] string
   StringLen=strlen(Setup.Hardware.Paras[Stn]);
   if (!StringLen) continue;
   LoPar=atoi(Setup.Hardware.Paras[Stn]);
   H1=0; H2=0;
   Ptr=rindex(Setup.Hardware.Paras[Stn],','); if (Ptr != NULL) H1=atoi(Ptr+1);
   Ptr=rindex(Setup.Hardware.Paras[Stn],'-'); if (Ptr != NULL) H2=atoi(Ptr+1);
   HiPar=MAX(H1,H2); if (HiPar==0) HiPar=LoPar;                             //We calculated HiPar but we dont require it
   //Grasp Setup.Parameter.Name[] by tokenizing Setup.Hardware.ParaNames[Stn] string
      if (StringLen)
      {
      Tokenize(Setup.Hardware.ParaNames[Stn],',',&NTokens,Token);
      ParNo=LoPar-1;
      for (i=0;i<NTokens;++i)
         {
         Ptr=index(Token[i],'-');
         if (Ptr !=NULL)
            {
            Tokenize(Token[i],'-',&Np,Broken); //g_print("Broken[0]=%s, Broken[1]=%s \n",Broken[0],Broken[1]);
            ParseName(Broken[1],Alpha,&NLast); ParseName(Broken[0],Alpha,&NFirst); 
            for (j=0;j<NLast-NFirst+1;++j,++ParNo) sprintf(Setup.Parameter.Name[ParNo],"%s%d",Alpha,NFirst+j);
            }
         else
            {
            Tokenize(Token[i],',',&Np,Broken);
            //printf("In GraspParameterNames else loop, ParaName=%s\n", Broken);
            for (j=0;j<Np;++j,++ParNo) strcpy(Setup.Parameter.Name[ParNo],Broken[j]);
            }
         }
      }
   }
}
//----------------------------------------------------------------------------------------------------------------------
void ParameterSetup(void)                                         //Go through Hardware Setup and create Parameter Setup
{
gint Stn,L,LA,i,Pos,PosA,Lo,LoA,NoHi,NoHiA,NoMore,Start,StartA,LoP,HiP;
gchar c,LoPar[8],HiPar[8],LoSub[8],HiSub[8];

Setup.Hardware.NCrates=CLAMP(Setup.Hardware.NCrates,1,2);                                                //Extra precaution
for (Stn=0;Stn<Setup.Hardware.NCrates*MAX_VME_STNS;Stn++)
    {
    if (strlen(Setup.Hardware.Paras[Stn]))
       {
       NoMore=0; Start=0; StartA=0;
       do
          {
          //------Decode Para-----
          L=strlen(&Setup.Hardware.Paras[Stn][Start]);
          for (i=0;i<=L;++i) 
              if ((Setup.Hardware.Paras[Stn][Start+i]==';') || (Setup.Hardware.Paras[Stn][Start+i]==',')) { L=i; break; }
          for (i=0,Lo=1,Pos=0;i<=L;++i)
              {
              c=Setup.Hardware.Paras[Stn][Start+i]; 
              switch (c)
                {
                case '0': case '1': case '2': case '3': case '4': case '5': case '6': case '7': case '8': case '9':
                          if (Lo) LoPar[Pos]=c; else HiPar[Pos]=c;
                          Pos++;
                          if (Pos>5) { ParaError(Stn); return; }
                          break;
                case '-': if (Lo) { LoPar[Pos]='\0'; Lo=0; Pos=0; } else { ParaError(Stn); return; }
                          break;
                case '\0': NoMore=1;
                case ';': case ',':
                          if (Lo) { LoPar[Pos]='\0'; NoHi=1; Lo=0; }
                          else    { HiPar[Pos]='\0'; NoHi=0; Lo=1; }
                          if (!strlen(LoPar)) { ParaError(Stn); return; }
                          if ( (!NoHi) && (!strlen(HiPar)) ) { ParaError(Stn); return; }
                          ParsePar(Stn,LoPar,HiPar,NoHi,&LoP,&HiP); Pos=0; Start+=i+1;
                          break;
                default: ParaError(Stn); return;
                }             //End of switch (c)
              }               //End of for (i=
          //-----End Decode Para----
          //-----Decode SubAddr----
          LA=strlen(&Setup.Hardware.SubAddr[Stn][StartA]);
          for (i=0;i<=LA;++i) 
              if ( (Setup.Hardware.SubAddr[Stn][StartA+i]==';') || (Setup.Hardware.SubAddr[Stn][StartA+i]==',') ) 
                 { LA=i; break; }
          if (!LA) { SubAddrError(Stn); return; }
          for (i=0,LoA=1,PosA=0;i<=LA;++i)
              {
              c=Setup.Hardware.SubAddr[Stn][StartA+i];
              switch (c)
                 {
                 case '0': case '1': case '2': case '3': case '4': case '5': case '6': case '7': case '8': case '9':
                           if (LoA) LoSub[PosA]=c; else HiSub[PosA]=c;
                           PosA++;
                           if (PosA>3) { SubAddrError(Stn); return; }
                           break;
                 case '-': if (LoA) { LoSub[PosA]='\0'; LoA=0; PosA=0; } else { SubAddrError(Stn); return; }
                           break;
                 case '\0': case ';': case ',':
                           if (LoA) { LoSub[PosA]='\0'; NoHiA=1; LoA=0; }
                           else     { HiSub[PosA]='\0'; NoHiA=0; LoA=1; }
                           if (!strlen(LoSub)) { SubAddrError(Stn); return; }
                           if ( (!NoHiA) && (!strlen(HiSub)) ) { SubAddrError(Stn); return; }
                           ParseSub(Stn,LoSub,HiSub,NoHiA,LoP,HiP); PosA=0; StartA+=i+1;
                           break;
                 default: SubAddrError(Stn); return;
                 }
              }  
          //-----End Decode SubAddr-----
          //22 July 2014: Decoding of ParaNames is now done by GraspParameterNames() outside this loop 
          }while (!NoMore);   //End of do
       }                      //End of if (strlen
    }                         //End of for (Stn=
GraspParameterNames();
Setup.ListMode.BufSiz=CLAMP(Setup.ListMode.BufSiz,2*EVT_TRG_REG*Setup.Parameter.NPar,MAX_BUFSIZ);
Setup.ListMode.BufSiz=(Setup.ListMode.BufSiz/2/Setup.Parameter.NPar/EVT_TRG_REG)*2*Setup.Parameter.NPar*EVT_TRG_REG;
if (Setup.ListMode.BufSiz<=0) Setup.ListMode.BufSiz=2*Setup.Parameter.NPar*EVT_TRG_REG;
}
//----------------------------------------------------------------------------------------------------------------------
void ParaListClosed(GtkWidget *W,gpointer Data)
{ ParaListVisible=FALSE; }
//----------------------------------------------------------------------------------------------------------------------
void ParameterList(GtkWidget *W,gpointer Data)
{
gint i;
static GdkColor HeadingBg  = {0,0xF000,0x7000,0x7000};
static GdkColor HeadingFg  = {0,0xFFFF,0xFFFF,0xFFFF};
GtkStyle *HeadingStyle;
GtkWidget *VBox,*Label,*Table,*But,*ScrollW;
gchar Str[MAX_TEXT_FIELD];
static gchar Heading[3][10] = {"Para","Name","Resl"};
gint ColWidth[3] = {50,100,60};

HeadingStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<3;i++) { HeadingStyle->fg[i]=HeadingStyle->text[i]=HeadingFg; HeadingStyle->bg[i]=HeadingBg; }

if (ParaListVisible) gtk_widget_destroy(ParaListW);
ParaListW=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect(GTK_OBJECT(ParaListW),"destroy",G_CALLBACK(ParaListClosed),ParaListW);
gtk_window_set_title(GTK_WINDOW(ParaListW),"Para List");
gtk_widget_set_uposition(GTK_WIDGET(ParaListW),MonXRes-1+MainX,0);
gtk_container_set_border_width(GTK_CONTAINER(ParaListW),5);

VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(ParaListW),VBox);

Table=gtk_table_new(1,3,FALSE);
for (i=0;i<3;i++)
    {
    But=gtk_button_new_with_label(Heading[i]); SetStyleRecursively(But,HeadingStyle); 
    gtk_widget_set_size_request(But,ColWidth[i],-1);
    gtk_table_attach(GTK_TABLE(Table),But,i,i+1,0,1,GTK_FILL,GTK_SHRINK,0,0);
    }
gtk_box_pack_start(GTK_BOX(VBox),Table,FALSE,FALSE,2);

ScrollW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollW),GTK_POLICY_NEVER,GTK_POLICY_ALWAYS);
gtk_box_pack_start(GTK_BOX(VBox),ScrollW,FALSE,FALSE,0);
gtk_widget_set_size_request(ScrollW,-1,MonYRes-TopSpace-BotSpace);

Table=gtk_table_new(Setup.Parameter.NPar,3,FALSE);

for (i=0;i<Setup.Parameter.NPar;++i)
    {
    sprintf(Str,"%d",i+1); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[0],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,0,1,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    sprintf(Str,"%s",Setup.Parameter.Name[i]); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[1],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,1,2,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    sprintf(Str,"%d",Setup.Parameter.Chan[i]); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[2],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,2,3,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    }
for (i=0;i<Setup.Pseudo.N;++i)
    {
    sprintf(Str,"%d",Setup.Parameter.NPar+i+1); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[0],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,0,1,Setup.Parameter.NPar+i,Setup.Parameter.NPar+i+1,GTK_FILL,GTK_SHRINK,0,0);
    sprintf(Str,"%s",Setup.Pseudo.Name[i]); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[1],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,1,2,Setup.Parameter.NPar+i,Setup.Parameter.NPar+i+1,GTK_FILL,GTK_SHRINK,0,0);
    sprintf(Str,"%d",Setup.Pseudo.Size[i]); Label=gtk_label_new(Str);
    gtk_widget_set_size_request(GTK_WIDGET(Label),ColWidth[2],-1);
    gtk_table_attach(GTK_TABLE(Table),Label,2,3,Setup.Parameter.NPar+i,Setup.Parameter.NPar+i+1,GTK_FILL,GTK_SHRINK,0,0);
    }
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollW),Table);
gtk_style_unref(HeadingStyle);
ParaListVisible=TRUE; gtk_widget_show_all(ParaListW);
gtk_window_move(GTK_WINDOW(ParaListW),MonXRes-1+MainX,0);
}
//----------------------------------------------------------------------------------------------------------------------
void ListModeSettings(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*Label,*VBox,*HBox,*CList,*But;
static gchar *Titles[4] = {"No","Para No.","Lo Limit","Hi Limit"};
gchar Str[80],*Text[4],Col0[6],Col1[MAX_TEXT_FIELD],Col2[MAX_TEXT_FIELD],Col3[MAX_TEXT_FIELD];
gint i;

if (ProgramState == DoingSetup) { Attention(0,"Cant view the Parameter List\nin the current Program State"); return; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),Win);
gtk_window_set_title(GTK_WINDOW(Win),"List Mode Settings");
gtk_container_set_border_width(GTK_CONTAINER(Win),5);

VBox=gtk_vbox_new(FALSE,4); gtk_container_add(GTK_CONTAINER(Win),VBox);
if (Setup.ListMode.ListOn) sprintf(Str,"List Mode On"); else sprintf(Str,"List Mode Off");
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,TRUE,TRUE,0);
sprintf(Str,"Buffer Size: %d",Setup.ListMode.BufSiz);
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,TRUE,TRUE,0);
if (Setup.ListMode.ListOn)
   {
   switch (Setup.ListMode.Compr)
          {
          case 1: sprintf(Str,"File Format: Normal (zls scheme)"); break;
          case 2: sprintf(Str,"File Format: Advanced (gls scheme)"); break;
          case 0: sprintf(Str,"File Format: Candle (nsc scheme)"); 
          }
   Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,TRUE,TRUE,0);
   if (Setup.ListMode.NoOfLGates)
      {
      gtk_widget_set_size_request(GTK_WIDGET(Win),262,312);
      CList=gtk_clist_new_with_titles(4,Titles);
      for (i=0;i<4;++i) gtk_clist_set_column_width(GTK_CLIST(CList),i,60);                                   //Same width for all columns
      gtk_clist_set_column_width(GTK_CLIST(CList),0,20);                                                       //Except 1st column narrow
      gtk_box_pack_start(GTK_BOX(VBox),CList,FALSE,FALSE,0);
      for (i=0;i<Setup.ListMode.NoOfLGates;++i)
          {
          sprintf(Col0,"%d",i+1);                            Text[0]=Col0;
          sprintf(Col1,"%5d",Setup.ListMode.LGates[i].Para); Text[1]=Col1;
          sprintf(Col2,"%5d",Setup.ListMode.LGates[i].Lo);   Text[2]=Col2;
          sprintf(Col3,"%5d",Setup.ListMode.LGates[i].Hi);   Text[3]=Col3;
          gtk_clist_append((GtkCList *)CList,Text);
          }
      }
   }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),Win);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void OnedSpecSettings(GtkWidget *W,gpointer Data) 
{
GtkWidget *Win,*VBox,*HBox,*Label,*CList,*But,*ScrW;
static gchar *Titles[5] = {"No","Para","Size","1d Gates","2d Gates"};
gchar Str[80],*Text[5],Col0[6],Col1[MAX_TEXT_FIELD],Col2[MAX_TEXT_FIELD],Col3[MAX_TEXT_FIELD],Col4[MAX_TEXT_FIELD];
gint i;

if (ProgramState == DoingSetup) { Attention(0,"Cant view the Parameter List\nin the current Program State"); return; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),Win);
gtk_window_set_title(GTK_WINDOW(Win),"Spectra Settings");
gtk_container_set_border_width(GTK_CONTAINER(Win),5);

VBox=gtk_vbox_new(FALSE,4); gtk_container_add(GTK_CONTAINER(Win),VBox);
if (Setup.Oned.WSz==1) sprintf(Str,"No of 1d Spectra (16-bit)=%d",Setup.Oned.N); 
else                   sprintf(Str,"No of 1d Spectra (32-bit)=%d",Setup.Oned.N);
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,FALSE,0);

ScrW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start(GTK_BOX(VBox),ScrW,TRUE,TRUE,0);
CList=gtk_clist_new_with_titles(5,Titles);
for (i=0;i<5;++i) gtk_clist_set_column_width(GTK_CLIST(CList),i,60);                                   //Same width for all columns
gtk_clist_set_column_width(GTK_CLIST(CList),0,20);                                                       //Except 1st column narrow
gtk_container_add(GTK_CONTAINER(ScrW),CList);
for (i=0;i<Setup.Oned.N;++i)
    {
    sprintf(Col0,"%d",i+1);                            Text[0]=Col0;
    sprintf(Col1,"%5d",Setup.Oned.Par[i]);             Text[1]=Col1;
    sprintf(Col2,"%5d",Setup.Oned.Chan[i]);            Text[2]=Col2;
    sprintf(Col3,"%5d",Setup.Oned.Gate1[i].NGates);    Text[3]=Col3;
    sprintf(Col4,"%5d",Setup.Oned.Gate2[i].NGates);    Text[4]=Col4;
    gtk_clist_append((GtkCList *)CList,Text);
    }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),Win);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void TwodSpecSettings(GtkWidget *W,gpointer Data) 
{
GtkWidget *Win,*VBox,*HBox,*Label,*CList,*But,*ScrW;
static gchar *Titles[6] = {"No","X-Para","Y-Para","Size","1d Gates","2d Gates"};
gchar Str[80],*Text[6],Col0[6],Col1[MAX_TEXT_FIELD],Col2[MAX_TEXT_FIELD],Col3[MAX_TEXT_FIELD],Col4[MAX_TEXT_FIELD],Col5[MAX_TEXT_FIELD];
gint i;

if (ProgramState == DoingSetup) { Attention(0,"Cant view the Parameter List\nin the current Program State"); return; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),Win);
gtk_window_set_title(GTK_WINDOW(Win),"Spectra Settings");
gtk_container_set_border_width(GTK_CONTAINER(Win),5);

VBox=gtk_vbox_new(FALSE,4); gtk_container_add(GTK_CONTAINER(Win),VBox);
if (Setup.Oned.WSz==1) sprintf(Str,"No of 2d Spectra (16-bit)=%d",Setup.Twod.N); 
else                   sprintf(Str,"No of 2d Spectra (32-bit)=%d",Setup.Twod.N);
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,FALSE,0);

ScrW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start(GTK_BOX(VBox),ScrW,TRUE,TRUE,0);
CList=gtk_clist_new_with_titles(6,Titles);
for (i=0;i<6;++i) gtk_clist_set_column_width(GTK_CLIST(CList),i,60);                                   //Same width for all columns
gtk_clist_set_column_width(GTK_CLIST(CList),0,20);                                                       //Except 1st column narrow
gtk_container_add(GTK_CONTAINER(ScrW),CList);
for (i=0;i<Setup.Twod.N;++i)
    {
    sprintf(Col0,"%d",i+1);                                          Text[0]=Col0;
    sprintf(Col1,"%5d",Setup.Twod.XPar[i]);                          Text[1]=Col1;
    sprintf(Col2,"%5d",Setup.Twod.YPar[i]);                          Text[2]=Col2;
    sprintf(Col3,"%4dx%4d",Setup.Twod.XChan[i],Setup.Twod.YChan[i]); Text[3]=Col3;
    sprintf(Col4,"%5d",Setup.Twod.Gate1[i].NGates);                  Text[4]=Col4;
    sprintf(Col5,"%5d",Setup.Twod.Gate2[i].NGates);                  Text[5]=Col5;
    gtk_clist_append((GtkCList *)CList,Text);
    }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),Win);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void PseudoSettings(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*VBox,*HBox,*Label,*CList,*But,*ScrW;
static gchar *Titles[5] = {"No","Para 1","Para 2","Size","Type"};
gchar Str[80],*Text[5],Col0[6],Col1[MAX_TEXT_FIELD],Col2[MAX_TEXT_FIELD],Col3[MAX_TEXT_FIELD],Col4[MAX_TEXT_FIELD];
gint i;

if (ProgramState == DoingSetup) { Attention(0,"Cant view the Parameter List\nin the current Program State"); return; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),Win);
gtk_window_set_title(GTK_WINDOW(Win),"Pseudo Parameters");
gtk_container_set_border_width(GTK_CONTAINER(Win),5);

VBox=gtk_vbox_new(FALSE,4); gtk_container_add(GTK_CONTAINER(Win),VBox);
sprintf(Str,"No of Pseudo Parameters=%d",Setup.Pseudo.N); 
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,FALSE,0);

ScrW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start(GTK_BOX(VBox),ScrW,TRUE,TRUE,0);
CList=gtk_clist_new_with_titles(5,Titles);
for (i=0;i<5;++i) gtk_clist_set_column_width(GTK_CLIST(CList),i,60);                                   //Same width for all columns
gtk_clist_set_column_width(GTK_CLIST(CList),0,20);                                                       //Except 1st column narrow
gtk_container_add(GTK_CONTAINER(ScrW),CList);
for (i=0;i<Setup.Pseudo.N;++i)
    {
    sprintf(Col0,"%d",i+1);                   Text[0]=Col0;
    sprintf(Col1,"%5d",Setup.Pseudo.P1[i]);   Text[1]=Col1;
    sprintf(Col2,"%5d",Setup.Pseudo.P2[i]);   Text[2]=Col2;
    sprintf(Col3,"%5d",Setup.Pseudo.Size[i]); Text[3]=Col3;
    switch (Setup.Pseudo.Type[i])
           {
           case Sum:          sprintf(Col4,"Sum");          break;
           case Product:      sprintf(Col4,"Product");      break;
           case Ratio:        sprintf(Col4,"Ratio");        break;
           case Position:     sprintf(Col4,"Position");     break;
           case PI:           sprintf(Col4,"PI");           break;
           case Multiplicity: sprintf(Col4,"Multiplicity"); break;
           case User:         sprintf(Col4,"User");         break;
           case Array:        sprintf(Col4,"Array");        break;
           case BGated:       sprintf(Col4,"BGated");
           }
    Text[4]=Col4;
    gtk_clist_append((GtkCList *)CList,Text);
    }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),Win);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void ScalerSettings(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*VBox,*HBox,*Label,*But;
gchar Str[1024];
gint i;

if (ProgramState == DoingSetup) { Attention(0,"Cant view the Parameter List\nin the current Program State"); return; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),Win);
gtk_window_set_title(GTK_WINDOW(Win),"Scaler Settings");
gtk_container_set_border_width(GTK_CONTAINER(Win),5);

VBox=gtk_vbox_new(FALSE,4); gtk_container_add(GTK_CONTAINER(Win),VBox);
HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,TRUE,TRUE,0);
sprintf(Str,"Number of Scalers=%d",Setup.Scaler.NSc); Label=gtk_label_new(Str);
gtk_box_pack_start(GTK_BOX(HBox),Label,TRUE,TRUE,0);
for (i=0;i<Setup.Scaler.NSc;++i)
    {
    HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,TRUE,TRUE,0);
    sprintf(Str,"%d %-30s C=%d N=%d A=%d BaseAddr=%X",i+1,Setup.Scaler.Name[i],Setup.Scaler.C[i],Setup.Scaler.N[i],
            Setup.Scaler.A[i],Setup.Scaler.BaseAddr[i]);
    Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,TRUE,FALSE,0);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),Win);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------

