#define GTK_ENABLE_BROKEN
#include <gtk/gtk.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include "lamps.h"
#include "common.h"

//Function Templates
void Attention(gint XPos,gchar *Messg);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
void SAttention(gchar *Messg);
gboolean CalibrationPeaks(gint WinNo,gint SNo,gint NPk,gint NTPk,gdouble *Pk,gint Lo,gint Hi);              //In plot1.c
gint DoFit(gint NPts,gint NPara,gdouble (*Func)(),gint Option,gdouble *X,gdouble *Y,gdouble *P,
           gdouble *Err,enum FitFlags *Flag,gchar *Messg);                                                  //In plot1.c
gdouble CalibFunc(gint i,gdouble *P,gdouble *X);                                                            //In plot1.c
void SaveCalib(GtkWidget *W,gpointer Unused);                                                               //In calib.c

//Structure definition
struct BulkCalibType {gchar Source[MAX_TEXT_FIELD]; gint Lo; gint Hi; GtkWidget *W; GtkWidget *ELo; GtkWidget *EHi;};

//External Global variables
extern struct Setup Setup;
extern enum ProgramState ProgramState;
extern gint TopSpace;
extern guint16 *Oned16;
extern guint32 *Oned32,*Proj;
extern gint Off1d[MAX_1D];
extern struct FitType Fit;                                                                          //The Fit parameters
extern struct Calibration Calibration[MAX_TOTAL_PAR];                                  //Computed calibration parameters

//Managed to avoid new global variables completely
//----------------------------------------------------------------------------------------------------------------------
void DestroyBC(GtkWidget *W,struct BulkCalibType *BulkCalibData)
{
g_free(BulkCalibData); BulkCalibData=NULL;
if (ProgramState==BulkCal) ProgramState=Free;
}
//----------------------------------------------------------------------------------------------------------------------
gboolean DeleteBCProgress(GtkWidget *W,GdkEvent *Event,gpointer Unused)
{
if (ProgramState != Free) { Attention(0,"Cant quit now. Bulk Calibration in progress"); return TRUE; };
return FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void DestroyBCProgress(GtkWidget *W,gpointer Unused)
{
if (ProgramState == Free) gtk_widget_destroy(W);
else                      Attention(0,"Cant quit now. Bulk Calibration in progress");
}
//----------------------------------------------------------------------------------------------------------------------
void AutoCalEu152(gint SNo,gint Lo,gint Hi,gboolean *Success)
{
gint Par,i,j;
gdouble m,Pk[20],Pl[8],P[4],Err[4];
enum FitFlags Flag[4];
gchar Messg[40];
gdouble Eg[8]={121.78,244.70,344.28,443.90,778.90,964.13,1112.11,1408.01};

if (!CalibrationPeaks(-1,SNo,11,20,Pk,Lo,Hi)) { *Success=FALSE; return; }    //Locate 11 strongest peaks among (upto) 20
Par=Setup.Oned.Par[SNo];                                                      //Parameter number (numbering starts at 1)
for (i=0;i<11;++i) Pk[i]*=Setup.Parameter.Chan[Par-1]/Setup.Oned.Chan[SNo];         //Scale up the peak positions to ADC
m=Eg[7]/Pk[10];                                                             //1 point calib taking last point as 1408KeV
for (i=0;i<8;++i)                                                 //Identify which of the Eg[8] come nearest to which Pk
   {
   for (j=0;j<11;++j) if (fabs(Eg[i]-m*Pk[j]) < 13.0) { Pl[i]=Pk[j]; break; }               //Delta of 13.0 is arbitrary
   }                                                                         //The ordered peaks positions are now in Pl 
P[0]=0.1; P[1]=m; P[2]=1.e-4; P[3]=1.e-6;
Flag[0]=Flag[1]=Flag[2]=Flag[3]=Variable;                                                     //We include the sqrt term
*Success=!DoFit(8,4,CalibFunc,1,Pl,Eg,P,Err,Flag,Messg);               //Fit the 8 calibration points to a straight line
if (*Success)                                                                          //Save the calibration parameters
   {
   for (i=0;i<4;i++) Calibration[Par-1].P[i]=P[i];
   strcpy(Calibration[Par-1].Units,"KeV");
   }
}
//----------------------------------------------------------------------------------------------------------------------
void AutoCalCo60(gint SNo,gint Lo,gint Hi,gboolean *Success)
{
gint Par,i;
gdouble Pk[2];
const gdouble Eg[2]={1173.2,1332.5};                                                      //Source gamma energies in KeV

if (!CalibrationPeaks(-1,SNo,2,4,Pk,Lo,Hi)) { *Success=FALSE; return; }    //Locate the 2 strongest peaks among (upto) 4
Par=Setup.Oned.Par[SNo];                                                      //Parameter number (numbering starts at 1)
for (i=0;i<2;++i) Pk[i]*=Setup.Parameter.Chan[Par-1]/Setup.Oned.Chan[SNo];          //Scale up the peak positions to ADC
strcpy(Calibration[Par-1].Units,"KeV");
Calibration[Par-1].P[1]=(Eg[1]-Eg[0])/(Pk[1]-Pk[0]);                                                             //Slope
Calibration[Par-1].P[0]=Eg[0]-Calibration[Par-1].P[1]*Pk[0];                                                 //Intercept
Calibration[Par-1].P[2]=Calibration[Par-1].P[3]=0.;
*Success=TRUE; return;
}
//----------------------------------------------------------------------------------------------------------------------
void AutoCalThC(gint SNo,gint Lo,gint Hi,gboolean *Success)
{
gdouble Pk[5],P[4],Err[4];
enum FitFlags Flag[4];
gchar Messg[40];
gint Par,i;
gdouble Ea[5]={4.845,5.790,6.339,7.067,8.377};                                                   //Source alpha energies

if (!CalibrationPeaks(-1,SNo,5,5,Pk,Lo,Hi)) { *Success=FALSE; return; }    //Locate the 5 strongest peaks among (upto) 5
Par=Setup.Oned.Par[SNo];                                                      //Parameter number (numbering starts at 1)
for (i=0;i<5;++i) Pk[i]*=Setup.Parameter.Chan[Par-1]/Setup.Oned.Chan[SNo];          //Scale up the peak positions to ADC
P[0]=P[1]=1.; Flag[0]=Flag[1]=Variable; P[2]=P[3]=0.0; Flag[2]=Flag[3]=Fixed;                              //Linear case
*Success=!DoFit(5,4,CalibFunc,1,Pk,Ea,P,Err,Flag,Messg);               //Fit the 5 calibration points to a straight line
if (*Success)                                                                          //Save the calibration parameters
   {
   for (i=0;i<4;i++) Calibration[Par-1].P[i]=P[i];
   strcpy(Calibration[Par-1].Units,"MeV");
   }
}
//----------------------------------------------------------------------------------------------------------------------
void *BulkCalibrate(gpointer BulkCalibData)
{
gint SNo;
struct BulkCalibType *BulkCalibData1;
gchar Source[MAX_TEXT_FIELD],Str[256];
gint Lo,Hi;
GtkWidget *Win,*HBox,*VBox,*Label,*But,*ScrollW,*VBox1;
GtkAdjustment *Adj;
gboolean Success;
static GdkColor Red   =  {0,0xffff,0x0000,0x0000};
static GdkColor Blue  =  {0,0x0000,0x0000,0xffff};
GtkStyle *RedStyle,*BlueStyle;

BulkCalibData1=BulkCalibData;
strcpy(Source,BulkCalibData1->Source); Lo=BulkCalibData1->Lo; Hi=BulkCalibData1->Hi;

gdk_threads_enter();
RedStyle=gtk_style_copy(gtk_widget_get_default_style());
for (int i=0;i<5;i++) { RedStyle->fg[i]=RedStyle->text[i]=Red; RedStyle->bg[i]=Red; }
BlueStyle=gtk_style_copy(gtk_widget_get_default_style());
for (int i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=Blue; BlueStyle->bg[i]=Blue; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(Win),"Bulk Calibration Progress");
gtk_widget_set_size_request(GTK_WIDGET(Win),-1,700);
g_signal_connect(GTK_OBJECT(Win),"delete_event",G_CALLBACK(DeleteBCProgress),NULL);
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(DestroyBCProgress),NULL);
gtk_container_set_border_width(GTK_CONTAINER(Win),10);
VBox=gtk_vbox_new(FALSE,10); gtk_container_add(GTK_CONTAINER(Win),VBox);

HBox=gtk_vbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Auto Calibration of all 1d spectra");
SetStyleRecursively(Label,BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

HBox=gtk_vbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
sprintf(Str,"Source:%s",Source);
Label=gtk_label_new(Str);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

HBox=gtk_vbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
sprintf(Str,"Spectrum region from %d to %d",Lo,Hi);
Label=gtk_label_new(Str);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

ScrollW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollW),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
gtk_box_pack_start(GTK_BOX(VBox),ScrollW,TRUE,TRUE,0);
VBox1=gtk_vbox_new(FALSE,4);
gtk_widget_set_size_request(GTK_WIDGET(ScrollW),-1,560);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollW),VBox1);
Adj=gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(ScrollW));

HBox=gtk_hbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Start ...");
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

HBox=gtk_hbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("    Save\nCalibration"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SaveCalib),Win);
But=gtk_button_new_with_label("Dismiss"); gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,6);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(DestroyBCProgress),Win);

gtk_widget_show_all(Win); gtk_window_move(GTK_WINDOW(Win),0,TopSpace+16);
gdk_threads_leave();

for (SNo=0;SNo<Setup.Oned.N;++SNo)
   {
   if (!strcmp(Source,"ThC")) AutoCalThC(SNo,Lo,Hi,&Success);
   else if (!strcmp(Source,"Co60")) AutoCalCo60(SNo,Lo,Hi,&Success);
   else AutoCalEu152(SNo,Lo,Hi,&Success);
   if (Success) sprintf(Str,"Calibration: Spec#%d: success",SNo+1);
   else         sprintf(Str,"Calibration: Spec#%d: failure",SNo+1);
   gdk_threads_enter();
   HBox=gtk_hbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
   Label=gtk_label_new(Str);
   if (Success) SetStyleRecursively(Label,BlueStyle); else SetStyleRecursively(Label,RedStyle);
   gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
   gtk_adjustment_set_value(Adj,gtk_adjustment_get_upper(Adj)-gtk_adjustment_get_page_size(Adj));
   gtk_widget_show_all(Win);
   gdk_threads_leave();
   }

ProgramState=Free; 
gdk_threads_enter(); gtk_style_unref(RedStyle); gtk_style_unref(BlueStyle); gdk_threads_leave();
pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void StartBC(GtkWidget *W,gpointer BulkCalibData)
{
pthread_t BC;
struct BulkCalibType *BulkCalibData1;

BulkCalibData1=BulkCalibData;
if (ProgramState==DoingBulkCal) return;                                        //In case of user quickly clicking twice!
ProgramState=DoingBulkCal;
if (GTK_IS_WIDGET(BulkCalibData1->W)) gtk_widget_destroy(BulkCalibData1->W);
pthread_create(&BC,NULL,BulkCalibrate,BulkCalibData);                                                     //Start thread
}
//----------------------------------------------------------------------------------------------------------------------
void BC_Lo(GtkWidget *W,struct BulkCalibType *BulkCalibData)
{
BulkCalibData->Lo=atoi(gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void BC_Hi(GtkWidget *W,struct BulkCalibType *BulkCalibData)
{
BulkCalibData->Hi=atoi(gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void BC_Source(GtkWidget *W,struct BulkCalibType *BulkCalibData)
{
gchar Str[MAX_TEXT_FIELD];

strcpy(BulkCalibData->Source,gtk_entry_get_text(GTK_ENTRY(W)));
//Setup the default ROIs for each source. These work only for our test data, the user must carefully set them
if (!strcmp(BulkCalibData->Source,"ThC"))                                                   //Default ROI for ThC source
   {
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->ELo),"101");
   sprintf(Str,"%d",Setup.Oned.Chan[0]-6);
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->EHi),Str);
   }
else if (!strcmp(BulkCalibData->Source,"Co60"))                                            //Default ROI for Co60 source
   {
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->ELo),"101");
   sprintf(Str,"%d",Setup.Oned.Chan[0]-6);
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->EHi),Str);
   }
else                                                                                      //Default ROI for Eu152 source
   {
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->ELo),"450");
   sprintf(Str,"%d",Setup.Oned.Chan[0]-2000);
   gtk_entry_set_text(GTK_ENTRY(BulkCalibData->EHi),Str);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void BulkCalib()
{
GtkWidget *VBox,*HBox,*Label,*But,*Combo;
gchar Str[MAX_TEXT_FIELD];
GList *GList;
struct BulkCalibType *BulkCalibData;
gint i;
static GdkColor Red   =  {0,0xffff,0x0000,0x0000};
static GdkColor Blue  =  {0,0x0000,0x0000,0xffff};
GtkStyle *RedStyle,*BlueStyle;

if (ProgramState != Free) { Attention(0,"Another task is in progress"); return; }
if (Setup.Oned.N==0) { Attention(0,"No 1d spectra defined!"); return; }
for (i=1;i<Setup.Oned.N;++i)
   if (Setup.Oned.Chan[i] != Setup.Oned.Chan[0])
      { Attention(0,"For Bulk Calibration, all the 1d spectra should be of the same size"); return; }

ProgramState=BulkCal;
BulkCalibData=g_new(struct BulkCalibType,1);                                                   //Must be destroyed later

RedStyle=gtk_style_copy(gtk_widget_get_default_style());
for (int i=0;i<5;i++) { RedStyle->fg[i]=RedStyle->text[i]=Red; RedStyle->bg[i]=Red; }
BlueStyle=gtk_style_copy(gtk_widget_get_default_style());
for (int i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=Blue; BlueStyle->bg[i]=Blue; }  

BulkCalibData->W=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(BulkCalibData->W),"Bulk Calibration");
g_signal_connect(GTK_OBJECT(BulkCalibData->W),"destroy",G_CALLBACK(DestroyBC),NULL);

gtk_container_set_border_width(GTK_CONTAINER(BulkCalibData->W),6);
VBox=gtk_vbox_new(FALSE,10); gtk_container_add(GTK_CONTAINER(BulkCalibData->W),VBox);

HBox=gtk_vbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Auto Calibration of all 1d spectra"); SetStyleRecursively(Label,BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

HBox=gtk_hbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Calibration source:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
Combo=gtk_combo_new(); gtk_box_pack_start(GTK_BOX(HBox),Combo,FALSE,FALSE,0);
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(Combo)->entry),FALSE);
gtk_widget_set_size_request(Combo,150,-1);
GList=NULL; GList=g_list_append(GList,"ThC"); GList=g_list_append(GList,"Co60"); GList=g_list_append(GList,"Eu152");
gtk_combo_set_popdown_strings(GTK_COMBO(Combo),GList);
gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"ThC"); strcpy(BulkCalibData->Source,"ThC");
g_signal_connect(GTK_OBJECT(GTK_COMBO(Combo)->entry),"changed",G_CALLBACK(BC_Source),BulkCalibData);

HBox=gtk_vbox_new(FALSE,6); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Please set the spectrrum region to avoid unwanted peaks"); SetStyleRecursively(Label,RedStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
Label=gtk_label_new("The defaults below are for example data only"); SetStyleRecursively(Label,RedStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Spectrum region from:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
BulkCalibData->ELo=gtk_entry_new_with_max_length(5);
gtk_box_pack_start(GTK_BOX(HBox),BulkCalibData->ELo,FALSE,FALSE,0);
gtk_widget_set_size_request(BulkCalibData->ELo,80,-1);
gtk_entry_set_text(GTK_ENTRY(BulkCalibData->ELo),"100"); BulkCalibData->Lo=100;
g_signal_connect(GTK_OBJECT(BulkCalibData->ELo),"changed",G_CALLBACK(BC_Lo),BulkCalibData);

Label=gtk_label_new("to:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
BulkCalibData->EHi=gtk_entry_new_with_max_length(5);
gtk_box_pack_start(GTK_BOX(HBox),BulkCalibData->EHi,FALSE,FALSE,0);
gtk_widget_set_size_request(BulkCalibData->EHi,80,-1); sprintf(Str,"%d",Setup.Oned.Chan[0]-5);
gtk_entry_set_text(GTK_ENTRY(BulkCalibData->EHi),Str); BulkCalibData->Hi=Setup.Oned.Chan[0]-5;
g_signal_connect(GTK_OBJECT(BulkCalibData->EHi),"changed",G_CALLBACK(BC_Hi),BulkCalibData);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("Start"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StartBC),BulkCalibData);
But=gtk_button_new_with_label("Dismiss"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),G_OBJECT(BulkCalibData->W));

gtk_widget_show_all(BulkCalibData->W); g_list_free(GList);
gtk_window_move(GTK_WINDOW(BulkCalibData->W),0,TopSpace+16);
gtk_style_unref(RedStyle); gtk_style_unref(BlueStyle); 
}
//----------------------------------------------------------------------------------------------------------------------

