#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <sys/stat.h>
#include "lamps.h"

//Function Templates
void SAttention(gchar *Messg);
void Attention(gint XPos,gchar *Messg);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void ZeroOned(gint SNo); void ZeroTwod(gint SNo);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
gint Read(gchar *ErrMessg); void StopNicely(void);
void fstart_(gchar *RunName,int Len); void fstop_();
void FileOpenNew(gchar *Title,GtkWidget *Parent,gint X,gint Y,gboolean OpenToRead,gchar *StartPath,gchar *Mask,
                 gboolean MaskEditable,void (*CallBack)(GtkWidget *,gpointer),gboolean Persist);
void CreateDir(void);

//External global variables
extern struct Setup Setup;                                                                         //The setup variables
extern enum ProgramState ProgramState;                                        //The current running state of the program
extern gchar RunName[120],PrevRun[120];                                           //Name of current run and previous run
extern enum AcqSignal AcqSignal;                                                                 //Stop,Pause and Resume
extern gboolean BatchRunning;
extern glong BytesWritten;
extern struct FileSelectType *FileX;
extern gchar SetupDir[MAX_DIR_STRLEN],ListFDir[MAX_DIR_STRLEN],SpecDir[MAX_DIR_STRLEN],
      BatDir[MAX_DIR_STRLEN],LogDir[MAX_DIR_STRLEN],MacroDir[MAX_DIR_STRLEN];                                //Dir prefs
extern GtkWidget *PrevWin;                      //Defined global in main.c. Used by setup.c, macro.c, control.c, batch.c
extern glong BuffersAcquired;                                                              //Defined global in control.c
extern gint TopSpace;

//Global Variables used in this file only
struct Bat *Bat;                                     //This structure holds widgets of the batch processing setup screen
GtkWidget *ParentWin;                                    //Need this in Batch Acquisition to make the parent insensitive
gboolean BatStop;                                                                  //Controls stopping batch acquisition

//Function templates and global variables for threads
void *AcquireData(gpointer Data); void *ControlBatch(gpointer Data);
pthread_t Acq,CntlBat;
//----------------------------------------------------------------------------------------------------------------------
gboolean CloseBatchAcq(GtkWidget *W,GdkEvent *Event,gpointer Unused)
{
if (!gtk_widget_is_sensitive(W)) return TRUE;                           //Do not delete window if it was set insensitive
ProgramState=Free; g_free(Bat);
return FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void CancelBatAcq(GtkWidget *W,GtkWidget *BatWin)
{ gtk_widget_destroy(BatWin); ProgramState=Free; g_free(Bat); }
//----------------------------------------------------------------------------------------------------------------------
void BatRowSelect(gint Row,gpointer Data)
{ Bat->Row=GPOINTER_TO_INT(Data); }
//----------------------------------------------------------------------------------------------------------------------
void RunNameChanged(GtkWidget *W,gpointer Data)
{
Bat->Row=GPOINTER_TO_INT(Data);
strcpy(Setup.BatAcq.RunName[Bat->Row],gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void SelectSetF(GtkWidget *W,gpointer Unused)
{
GList *Node;                        //Note: The GList has the table elements in reverse order! and g_list_nth doesnt work!
gchar Str[MAX_FNAME_LENGTH+5];
gint i,j;

if (Bat->Row >= 0)
   {
   Node=g_list_last(GTK_TABLE(Bat->Table)->children);                                            //First element of table
   for (i=0;i<Bat->Row;++i) for (j=0;j<5;++j) Node=g_list_previous(Node);                   //Skip nodes upto SelectedRow
   for (j=0;j<2;++j)  Node=g_list_previous(Node);                                                     //Skip 2 more nodes

   if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
      { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
   sprintf(Setup.BatAcq.SetFName[Bat->Row],"%s/%s",FileX->Path,FileX->TargetFile);
   g_free(FileX);
   AbbreviateFileName(Str,Setup.BatAcq.SetFName[Bat->Row],18);
   gtk_label_set_text(GTK_LABEL(GTK_BIN(((GtkTableChild *)Node->data)->widget)->child),Str);  //Change text inside button
   }
else
   {
   if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
      { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
   sprintf(Setup.BatAcq.SetFName[0],"%s/%s",FileX->Path,FileX->TargetFile);
   g_free(FileX);
   AbbreviateFileName(Str,Setup.BatAcq.SetFName[0],18);
   gtk_label_set_text(GTK_LABEL(Bat->Lab[6]),Str);                                                 //Change text in label
   gtk_widget_show(Bat->Lab[6]);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void BatSetFChanged(GtkWidget *W,gpointer Data)
{
Bat->Row=GPOINTER_TO_INT(Data);
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Select Setup Files",ParentWin,50,225,TRUE,SetupDir,".set",FALSE,&SelectSetF,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void StartChanged(GtkWidget *W,gpointer Data)
{
Bat->Row=GPOINTER_TO_INT(Data);
strcpy(Setup.BatAcq.Start[Bat->Row],gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void QCriterion(GtkWidget *W,gpointer Data)
{
gint i,Row;

Row=GPOINTER_TO_INT(Data);
strcpy(Setup.BatAcq.Stop[Row],gtk_entry_get_text(GTK_ENTRY(W)));
for (i=0;i<3;++i) gtk_widget_set_sensitive(Bat->Crit[i],FALSE);
for (i=0;i<6;++i) gtk_widget_set_sensitive(Bat->Lab[i],FALSE);
switch (Setup.BatAcq.Stop[Row][0])
   {
   case 'D': gtk_widget_set_sensitive(Bat->Crit[0],TRUE); gtk_widget_set_sensitive(Bat->Lab[0],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[1],TRUE); break;
   case 'E': gtk_widget_set_sensitive(Bat->Crit[1],TRUE); gtk_widget_set_sensitive(Bat->Lab[2],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[3],TRUE); break;
   case 'L': gtk_widget_set_sensitive(Bat->Crit[2],TRUE); gtk_widget_set_sensitive(Bat->Lab[4],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[5],TRUE);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void StopAccept(GtkWidget *W,GtkWidget *But)
{
switch (Setup.BatAcq.Stop[Bat->Row][0])
   {
   case 'D': sprintf(Setup.BatAcq.Stop[Bat->Row],"Duration %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[0])));
             break;
   case 'E': sprintf(Setup.BatAcq.Stop[Bat->Row],"Events %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[1])));
             break;
   case 'L': sprintf(Setup.BatAcq.Stop[Bat->Row],"ListBytes %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[2])));
   }
gtk_label_set_text(GTK_LABEL(GTK_BIN(But)->child),Setup.BatAcq.Stop[Bat->Row]);               //Change text inside button
gtk_widget_set_sensitive(PrevWin,TRUE);
}
//----------------------------------------------------------------------------------------------------------------------
void StopChanged(GtkWidget *W,gpointer Data)
{
GtkWidget *Win,*HBox,*VBox,*Lab,*Combo,*But;
GList *GList;
gchar StrD[MAX_TEXT_FIELD],StrE[MAX_TEXT_FIELD],StrL[MAX_TEXT_FIELD];
gint i;

Bat->Row=GPOINTER_TO_INT(Data);
Win=gtk_window_new(GTK_WINDOW_TOPLEVEL); gtk_widget_set_sensitive(PrevWin,FALSE);
gtk_window_set_title(GTK_WINDOW(Win),"Change Stop");
gtk_window_set_transient_for(GTK_WINDOW(Win),GTK_WINDOW(PrevWin));
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(StopAccept),W);

VBox=gtk_vbox_new(FALSE,5); gtk_container_add(GTK_CONTAINER(Win),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),10);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Lab=gtk_label_new("Criterion"); gtk_box_pack_start(GTK_BOX(HBox),Lab,FALSE,FALSE,0);
Combo=gtk_combo_new();
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(Combo)->entry),FALSE);
gtk_box_pack_start(GTK_BOX(HBox),Combo,FALSE,FALSE,11);
GList=NULL; GList=g_list_append(GList,"Duration");
GList=g_list_append(GList,"Events"); GList=g_list_append(GList,"ListBytes");
gtk_combo_set_popdown_strings(GTK_COMBO(Combo),GList);
strcpy(StrD," 00:01:00"); strcpy(StrE," 10K"); strcpy(StrL," 10MB");
switch (Setup.BatAcq.Stop[Bat->Row][0])
   {
   case 'D': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"Duration");
             strcpy(StrD,index(Setup.BatAcq.Stop[Bat->Row],' '));
             break;
   case 'E': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"Events");
             strcpy(StrE,index(Setup.BatAcq.Stop[Bat->Row],' '));
             break;
   case 'L': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"ListBytes");
             strcpy(StrL,index(Setup.BatAcq.Stop[Bat->Row],' '));
   }
g_signal_connect(GTK_OBJECT(GTK_COMBO(Combo)->entry),"changed",G_CALLBACK(QCriterion),GINT_TO_POINTER(Bat->Row));

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Bat->Lab[0]=gtk_label_new("Duration"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[0],FALSE,FALSE,0);
Bat->Crit[0]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[0]),&StrD[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[0]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[0],FALSE,FALSE,12);
Bat->Lab[1]=gtk_label_new("hh:mm:ss"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[1],FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Bat->Lab[2]=gtk_label_new("Events"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[2],FALSE,FALSE,0);
Bat->Crit[1]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[1]),&StrE[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[1]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[1],FALSE,FALSE,22);
Bat->Lab[3]=gtk_label_new("e.g 3K, 5.5M, 1.2G"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[3],FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Bat->Lab[4]=gtk_label_new("ListBytes"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[4],FALSE,FALSE,0);
Bat->Crit[2]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[2]),&StrL[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[2]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[2],FALSE,FALSE,6);
Bat->Lab[5]=gtk_label_new("e.g 10.3KB, 7.8MB, 0.6GB");
gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[5],FALSE,FALSE,5);

for (i=0;i<3;++i) gtk_widget_set_sensitive(Bat->Crit[i],FALSE);
for (i=0;i<6;++i) gtk_widget_set_sensitive(Bat->Lab[i],FALSE);
switch (Setup.BatAcq.Stop[Bat->Row][0])
   {
   case 'D': gtk_widget_set_sensitive(Bat->Crit[0],TRUE); gtk_widget_set_sensitive(Bat->Lab[0],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[1],TRUE); break;
   case 'E': gtk_widget_set_sensitive(Bat->Crit[1],TRUE); gtk_widget_set_sensitive(Bat->Lab[2],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[3],TRUE); break;
   case 'L': gtk_widget_set_sensitive(Bat->Crit[2],TRUE); gtk_widget_set_sensitive(Bat->Lab[4],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[5],TRUE);
   }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
But=gtk_button_new_with_label("OK"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));

g_list_free(GList);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void MakeBatRow(gint Row,GtkWidget *Table)
{
gint ColWidth[5]={40,90,90,100,190};
GtkWidget *But,*Entry;
gchar Str[MAX_FNAME_LENGTH+10];
static GdkColor StopBg  = {0,0x9999,0x0000,0x0000};
static GdkColor StopFg  = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor SetupBg  = {0,0xFFFF,0xFFFF,0x0000};
GtkStyle *StopStyle,*SetupStyle;
gint i;

StopStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { StopStyle->bg[i]=StopBg; StopStyle->fg[i]=StopStyle->text[i]=StopFg; }
SetupStyle=gtk_style_copy(gtk_widget_get_default_style()); for (i=0;i<5;i++) SetupStyle->bg[i]=SetupBg;

sprintf(Str,"%02d",Row+1); But=gtk_button_new_with_label(Str);
gtk_widget_set_usize(GTK_WIDGET(But),ColWidth[0],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatRowSelect),GINT_TO_POINTER(Row));
gtk_table_attach(GTK_TABLE(Table),But,0,1,Row,Row+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.BatAcq.RunName[Row]);
gtk_widget_set_usize(GTK_WIDGET(Entry),ColWidth[1],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(RunNameChanged),GINT_TO_POINTER(Row));
gtk_table_attach(GTK_TABLE(Table),Entry,1,2,Row,Row+1,GTK_FILL,GTK_SHRINK,0,0);

AbbreviateFileName(Str,Setup.BatAcq.SetFName[Row],18);
But=gtk_button_new_with_label(Str); SetStyleRecursively(But,SetupStyle);
gtk_widget_set_usize(GTK_WIDGET(But),ColWidth[2],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatSetFChanged),GINT_TO_POINTER(Row));
gtk_table_attach(GTK_TABLE(Table),But,3,4,Row,Row+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.BatAcq.Start[Row]);
gtk_widget_set_usize(GTK_WIDGET(Entry),ColWidth[3],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(StartChanged),GINT_TO_POINTER(Row));
gtk_table_attach(GTK_TABLE(Table),Entry,5,6,Row,Row+1,GTK_FILL,GTK_SHRINK,0,0);

But=gtk_button_new_with_label(""); SetStyleRecursively(But,StopStyle);
gtk_widget_set_usize(GTK_WIDGET(But),ColWidth[4],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StopChanged),GINT_TO_POINTER(Row));
gtk_table_attach(GTK_TABLE(Table),But,6,7,Row,Row+1,GTK_FILL,GTK_SHRINK,0,0);
gtk_label_set_text(GTK_LABEL(GTK_BIN(But)->child),Setup.BatAcq.Stop[Row]);

gtk_style_unref(StopStyle); gtk_style_unref(SetupStyle);
}
//----------------------------------------------------------------------------------------------------------------------
void AcceptQuickBat(GtkWidget *W,gpointer Unused)
{
gint i;

gtk_widget_set_sensitive(PrevWin,TRUE);
if (GTK_IS_WIDGET(Bat->Table)) gtk_widget_destroy(Bat->Table);
Bat->Table=gtk_table_new(Setup.BatAcq.NBat,4,FALSE);
Bat->Row=0;
Setup.BatAcq.NBat=CLAMP(atoi(gtk_entry_get_text(GTK_ENTRY(Bat->QEntry[0]))),0,MAX_BAT);
for (i=0;i<Setup.BatAcq.NBat;++i)
    {
    sprintf(Setup.BatAcq.RunName[i],"%s%03d",gtk_entry_get_text(GTK_ENTRY(Bat->QEntry[1])),i+1);
    strcpy(Setup.BatAcq.SetFName[i],Setup.BatAcq.SetFName[0]);
    strcpy(Setup.BatAcq.Start[i],gtk_entry_get_text(GTK_ENTRY(Bat->QEntry[2])));
    }
switch (Setup.BatAcq.Stop[0][0])
   {
   case 'D': for (i=0;i<Setup.BatAcq.NBat;++i)
             sprintf(Setup.BatAcq.Stop[i],"Duration %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[0])));
             break;
   case 'E': for (i=0;i<Setup.BatAcq.NBat;++i)
             sprintf(Setup.BatAcq.Stop[i],"Events %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[1])));
             break;
   case 'L': for (i=0;i<Setup.BatAcq.NBat;++i)
             sprintf(Setup.BatAcq.Stop[i],"ListBytes %s",gtk_entry_get_text(GTK_ENTRY(Bat->Crit[2])));
   }
for (i=0;i<Setup.BatAcq.NBat;++i) MakeBatRow(i,Bat->Table);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Bat->ScrlW),Bat->Table);
gtk_widget_show_all(Bat->ScrlW);
}
//----------------------------------------------------------------------------------------------------------------------
void QuickBat(GtkWidget *W,gpointer Unused)
{
GtkWidget *Win,*But,*HBox,*VBox,*Lab,*Combo,*Frame,*VBox1;
GList *GList;
gchar Str[LONG_TEXT_FIELD],StrD[MAX_TEXT_FIELD],StrE[MAX_TEXT_FIELD],StrL[MAX_TEXT_FIELD];
gint i;

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL); gtk_widget_set_sensitive(PrevWin,FALSE); 
gtk_window_set_title(GTK_WINDOW(Win),"Quick Set"); ParentWin=Win;
gtk_window_set_transient_for(GTK_WINDOW(Win),GTK_WINDOW(PrevWin));
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(AcceptQuickBat),NULL);

VBox=gtk_vbox_new(FALSE,12); gtk_container_add(GTK_CONTAINER(Win),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),5);

Lab=gtk_label_new("Quick Set provides a starting point");
gtk_box_pack_start(GTK_BOX(VBox),Lab,FALSE,FALSE,0);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Lab=gtk_label_new("No of Runs"); gtk_box_pack_start(GTK_BOX(HBox),Lab,FALSE,FALSE,10);
Bat->QEntry[0]=gtk_entry_new_with_max_length(3);
sprintf(Str,"%d",Setup.BatAcq.NBat); gtk_entry_set_text(GTK_ENTRY(Bat->QEntry[0]),Str);
gtk_widget_set_size_request(GTK_WIDGET(Bat->QEntry[0]),40,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->QEntry[0],FALSE,FALSE,10);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Lab=gtk_label_new("Generic Run Name"); gtk_box_pack_start(GTK_BOX(HBox),Lab,FALSE,FALSE,10);
Bat->QEntry[1]=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH-4);
gtk_entry_set_text(GTK_ENTRY(Bat->QEntry[1]),"run");
gtk_widget_set_usize(GTK_WIDGET(Bat->QEntry[1]),90,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->QEntry[1],FALSE,FALSE,10);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("Setup File:");
i=-1;
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatSetFChanged),GINT_TO_POINTER(i));
gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,10);
Bat->Lab[6]=gtk_label_new("Current"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[6],FALSE,FALSE,10);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Lab=gtk_label_new("Start Delay"); gtk_box_pack_start(GTK_BOX(HBox),Lab,FALSE,FALSE,10);
Bat->QEntry[2]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->QEntry[2]),Setup.BatAcq.Start[0]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->QEntry[2]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->QEntry[2],FALSE,FALSE,10);

Frame=gtk_frame_new("Stop After"); gtk_frame_set_label_align(GTK_FRAME(Frame),0.5,0.0);
gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
VBox1=gtk_vbox_new(FALSE,5); gtk_container_add(GTK_CONTAINER(Frame),VBox1);
gtk_container_set_border_width(GTK_CONTAINER(VBox1),10);
HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
Lab=gtk_label_new("Criterion"); gtk_box_pack_start(GTK_BOX(HBox),Lab,FALSE,FALSE,0);
Combo=gtk_combo_new();
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(Combo)->entry),FALSE);
gtk_box_pack_start(GTK_BOX(HBox),Combo,FALSE,FALSE,11);
GList=NULL; GList=g_list_append(GList,"Duration");
GList=g_list_append(GList,"Events"); GList=g_list_append(GList,"ListBytes");
gtk_combo_set_popdown_strings(GTK_COMBO(Combo),GList);
strcpy(StrD," 00:01:00"); strcpy(StrE," 10K"); strcpy(StrL," 10MB");

switch (Setup.BatAcq.Stop[0][0])
   {
   case 'D': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"Duration");
             strcpy(StrD,index(Setup.BatAcq.Stop[0],' '));
             break;
   case 'E': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"Events");
             strcpy(StrE,index(Setup.BatAcq.Stop[0],' '));
             break;
   case 'L': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"ListBytes");
             strcpy(StrL,index(Setup.BatAcq.Stop[0],' '));
   }

i=0;
g_signal_connect(GTK_OBJECT(GTK_COMBO(Combo)->entry),"changed",G_CALLBACK(QCriterion),GINT_TO_POINTER(i));

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
Bat->Lab[0]=gtk_label_new("Duration"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[0],FALSE,FALSE,0);
Bat->Crit[0]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[0]),&StrD[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[0]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[0],FALSE,FALSE,12);
Bat->Lab[1]=gtk_label_new("hh:mm:ss"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[1],FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
Bat->Lab[2]=gtk_label_new("Events"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[2],FALSE,FALSE,0);
Bat->Crit[1]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[1]),&StrE[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[1]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[1],FALSE,FALSE,22);
Bat->Lab[3]=gtk_label_new("e.g 3K, 5.5M, 1.2G");
gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[3],FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox,FALSE,FALSE,0);
Bat->Lab[4]=gtk_label_new("ListBytes"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[4],FALSE,FALSE,0);
Bat->Crit[2]=gtk_entry_new_with_max_length(8);
gtk_entry_set_text(GTK_ENTRY(Bat->Crit[2]),&StrL[1]);
gtk_widget_set_size_request(GTK_WIDGET(Bat->Crit[2]),80,-1);
gtk_box_pack_start(GTK_BOX(HBox),Bat->Crit[2],FALSE,FALSE,6);
Bat->Lab[5]=gtk_label_new("e.g 10.3KB, 7.8MB, 0.6GB"); gtk_box_pack_start(GTK_BOX(HBox),Bat->Lab[5],FALSE,FALSE,5);

for (i=0;i<3;++i) gtk_widget_set_sensitive(Bat->Crit[i],FALSE);
for (i=0;i<6;++i) gtk_widget_set_sensitive(Bat->Lab[i],FALSE);
switch (Setup.BatAcq.Stop[0][0])
   {
   case 'D': gtk_widget_set_sensitive(Bat->Crit[0],TRUE); gtk_widget_set_sensitive(Bat->Lab[0],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[1],TRUE); break;
   case 'E': gtk_widget_set_sensitive(Bat->Crit[1],TRUE); gtk_widget_set_sensitive(Bat->Lab[2],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[3],TRUE); break;
   case 'L': gtk_widget_set_sensitive(Bat->Crit[2],TRUE); gtk_widget_set_sensitive(Bat->Lab[4],TRUE);
             gtk_widget_set_sensitive(Bat->Lab[5],TRUE);
   }

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
But=gtk_button_new_with_label("Accept"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));

g_list_free(GList);
gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void BatAdd(GtkWidget *W,gpointer Unused)
{
gint Row,End;

if (Setup.BatAcq.NBat == MAX_BAT) return;                                                                //Limit reached
Row=Setup.BatAcq.NBat;
++Setup.BatAcq.NBat;
if (Row)
   {
   strcpy(Setup.BatAcq.RunName[Row],Setup.BatAcq.RunName[Row-1]);
   strcpy(Setup.BatAcq.SetFName[Row],Setup.BatAcq.SetFName[Row-1]);
   strcpy(Setup.BatAcq.Start[Row],Setup.BatAcq.Start[Row-1]);
   strcpy(Setup.BatAcq.Stop[Row],Setup.BatAcq.Stop[Row-1]);
   }
else
   {
   strcpy(Setup.BatAcq.RunName[Row],"run001");
   strcpy(Setup.BatAcq.SetFName[Row],"Current");
   strcpy(Setup.BatAcq.Start[Row],"00:00:00");
   strcpy(Setup.BatAcq.Stop[Row],"Duration 00:01:00");
   }
MakeBatRow(Row,Bat->Table);
End=16.0*Row; if (Row>8) End=40.0*Row;                                                   //Fudging to scroll to the end!
gtk_adjustment_set_value(GTK_ADJUSTMENT(gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(Bat->ScrlW))),End);
gtk_widget_show_all(Bat->Table);
}
//----------------------------------------------------------------------------------------------------------------------
void BatClear(GtkWidget *W,gpointer Unused)
{
gint i;

if (!Setup.BatAcq.NBat) return;
Bat->Row=CLAMP(Bat->Row,0,Setup.BatAcq.NBat-1);
if (Setup.BatAcq.NBat>0) --Setup.BatAcq.NBat;
for (i=Bat->Row;i<Setup.BatAcq.NBat;++i)
    {
    strcpy(Setup.BatAcq.RunName[i],Setup.BatAcq.RunName[i+1]);
    strcpy(Setup.BatAcq.SetFName[i],Setup.BatAcq.SetFName[i+1]);
    strcpy(Setup.BatAcq.Start[i],Setup.BatAcq.Start[i+1]);
    strcpy(Setup.BatAcq.Stop[i],Setup.BatAcq.Stop[i+1]);
    }
Bat->Row=MIN(Bat->Row,Setup.BatAcq.NBat-1);
if (GTK_IS_WIDGET(Bat->Table)) gtk_widget_destroy(Bat->Table);
Bat->Table=gtk_table_new(Setup.BatAcq.NBat,4,FALSE);
for (i=0;i<Setup.BatAcq.NBat;++i) MakeBatRow(i,Bat->Table);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Bat->ScrlW),Bat->Table);
gtk_widget_show_all(Bat->ScrlW);
}
//----------------------------------------------------------------------------------------------------------------------
void BatClearAll(GtkWidget *W,gpointer Unused)
{
if (GTK_IS_WIDGET(Bat->Table)) gtk_widget_destroy(Bat->Table);
Bat->Row=0; Setup.BatAcq.NBat=0;
Bat->Table=gtk_table_new(Setup.BatAcq.NBat,4,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Bat->ScrlW),Bat->Table);
gtk_widget_show_all(Bat->ScrlW);
}
//----------------------------------------------------------------------------------------------------------------------
void LoadBatAcqF(GtkWidget *W,gpointer Unused)
{
gchar FName[2050],Str1[500],Str2[500];
gint i,j;
FILE *Fp;

if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(FName,"%s/%s",FileX->Path,FileX->TargetFile);
g_free(FileX);

BatClearAll(NULL,NULL);
if ((Fp=fopen(FName,"r")) != NULL)
   {
   fscanf(Fp,"%d",&Setup.BatAcq.NBat);
   for (i=0;i<Setup.BatAcq.NBat;++i)
       fscanf(Fp,"%d %s %s %s %s %s",&j,Setup.BatAcq.RunName[i],Setup.BatAcq.SetFName[i],
              Setup.BatAcq.Start[i],Str1,Str2);
   sprintf(Setup.BatAcq.Stop[i],"%s %s",Str1,Str2);
   fclose(Fp);
   }
for (i=0;i<Setup.BatAcq.NBat;++i) MakeBatRow(i,Bat->Table);
gtk_widget_show_all(Bat->Table); Bat->Row=0;
}
//----------------------------------------------------------------------------------------------------------------------
void LoadBatAcq(GtkWidget *W,gpointer Unused)
{
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Load Batch File",PrevWin,50,225,FALSE,BatDir,".acq",FALSE,&LoadBatAcqF,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void SaveBatAcqF(GtkWidget *W,gpointer Unused)
{
gchar FName[2058];
gint i;
FILE *Fp;

if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(FName,"%s/%s",FileX->Path,FileX->TargetFile);
g_free(FileX);

if ((Fp=fopen(FName,"w")) != NULL)
   {
   fprintf(Fp,"%d\n",Setup.BatAcq.NBat);
   for (i=0;i<Setup.BatAcq.NBat;++i)
       fprintf(Fp,"%d %s %s %s %s\n",i+1,Setup.BatAcq.RunName[i],Setup.BatAcq.SetFName[i],
               Setup.BatAcq.Start[i],Setup.BatAcq.Stop[i]);
   fclose(Fp);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void SaveBatAcq(GtkWidget *W,gpointer Unused)
{
FileX=g_new(struct FileSelectType,1);
FileOpenNew("Save Batch File",PrevWin,50,225,FALSE,BatDir,".acq",FALSE,&SaveBatAcqF,FALSE);
}
//----------------------------------------------------------------------------------------------------------------------
void *ControlBatch(gpointer Data)                                                  //Thread to control batch acquisition
{
gint i,j,Delay,Duration;
gpointer T;
gchar ErrMessg[200],Tc,
      DName[2050];
glong StBuffers,StBytes;
gfloat Tf;

if (BatchRunning) { SAttention("Batch process already running!"); pthread_exit(NULL); }
BatchRunning=TRUE; strcpy(PrevRun,"");
for (i=0;i<Setup.BatAcq.NBat;++i)
    {
    Setup.BatAcq.Current=i+1;
    if (BatStop) break;
    Delay=3600*atoi(Setup.BatAcq.Start[i]);
    T=index(Setup.BatAcq.Start[i],':'); Delay+=60*atoi(++T);
    T=rindex(Setup.BatAcq.Start[i],':'); Delay+=atoi(++T);
    for (j=0;j<10;++j) { if (ProgramState == Free) break; sleep(2); }           //Not a good way to synchronize threads!
    if (ProgramState != Free) { SAttention("Cannot get Free status\nAborting batch process"); break; }
    if (strcmp(Setup.BatAcq.SetFName[i],"Current"))
       {
       strcpy(Setup.FName,Setup.BatAcq.SetFName[i]);
       if (Read(ErrMessg)) { SAttention(ErrMessg); break; }                            //Read setup file--break on error
       }
    strcpy(PrevRun,RunName); strcpy(RunName,Setup.BatAcq.RunName[i]);

    switch (Setup.BatAcq.Stop[i][0])
           {
           case 'D': T=index(Setup.BatAcq.Stop[i],' '); Duration=3600*atoi(++T);                      //Stop by Duration
                     T=index(T,':'); Duration+=60*atoi(++T);
                     T=index(T,':'); Duration+=atoi(++T); break;
           case 'E': T=index(Setup.BatAcq.Stop[i],' '); Tf=(gfloat)atoi(++T);                           //Stop by Events
                     Tc=Setup.BatAcq.Stop[i][strlen(Setup.BatAcq.Stop[i])-1];
                     if (Tc=='K') Tf=1.0E3*Tf; else if (Tc=='M') Tf=1.0E6*Tf; else if (Tc=='G') Tf=1.0E9*Tf;
                     StBuffers=(glong)(Tf*2.0*Setup.Parameter.NPar/Setup.ListMode.BufSiz);
                     break;
           case 'L': T=rindex(Setup.BatAcq.Stop[i],' '); Tf=atof(++T);                              //Stop by List bytes
                     Tc=Setup.BatAcq.Stop[i][strlen(Setup.BatAcq.Stop[i])-2];
                     if (Tc=='K') Tf=1.0E3*Tf; else if (Tc=='M') Tf=1.0E6*Tf; else if (Tc=='G') Tf=1.0E9*Tf;
                     StBytes=(glong)Tf;
                     if (!Setup.ListMode.ListOn)
                        {
                        SAttention("Batch Error: Cant stop by List bytes\nList is off...Aborting batch");
                        BatchRunning=FALSE; pthread_exit(NULL);
                        }
           }
    if (AcqSignal != Stop) { SAttention("Acquisition already in progress"); BatchRunning=FALSE; pthread_exit(NULL); }
    sprintf(DName,"%s/Spec_%s",SpecDir,RunName);
    mkdir(DName,0755); //Create spec dir (no effect if it already exists)
    for (j=0;j<Setup.Oned.N;++j) sprintf(Setup.Files.Oned[j],"%s/%s%03d.z1d",DName,RunName,j+1);
    for (j=0;j<Setup.Twod.N;++j) sprintf(Setup.Files.Twod[j],"%s/%s%03d.z2d",DName,RunName,j+1);
    //We make no checks for spec and list file overwriting. Also, the spectra are always zeroed out.
    ProgramState=AcqOn; Setup.Spectra.NoZero=FALSE;
    ZeroOned(-1); ZeroTwod(-1);
    sleep(Delay);                                                                                    //Delay before start
    fstart_(RunName,strlen(RunName));                                                  //Call user initialisation routine
    pthread_create(&Acq,NULL,AcquireData,NULL);                                                       //Start acquisition
    switch (Setup.BatAcq.Stop[i][0])
           {
           case 'D': sleep(Duration);                                                                  //Stop by duration
                     StopNicely();
                     break;
           case 'E': while (TRUE)                                                                        //Stop by Events
                        {
                        sleep(10);                                                              //Check only every 10 sec
                        if (BuffersAcquired>=StBuffers) { StopNicely(); break; }
                        }
                     break;
           case 'L': while (TRUE)                                                                     //Stop by ListBytes
                        {
                        sleep(10);                                                              //Check only every 10 sec
                        if (BytesWritten>=StBytes) {  StopNicely(); break; }
                        }
           }
    }
strcpy(PrevRun,RunName); BatchRunning=FALSE; pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void StartBatAcq(GtkWidget *W,GtkWidget *BatWin)
{
gtk_widget_destroy(BatWin); g_free(Bat); ProgramState=Free;
pthread_create(&CntlBat,NULL,ControlBatch,NULL);
}
//----------------------------------------------------------------------------------------------------------------------
void BatchAcquire(GtkWidget *W,gpointer Unused)
{
static gchar *Titles[5]= {"No","Run Name","Setup File","Start Delay","Stop After"};
gint ColWidth[5]={40,90,90,100,190};
static GdkColor TitlesBg  = {0,0x0000,0x0000,0x7777};
static GdkColor TitlesFg  = {0,0xFFFF,0xFFFF,0xFFFF};
GtkStyle *TitlesStyle;
GtkWidget *Win,*VBox,*VBox1,*HBox,*Table,*TitlesBut,*But;
gint i;

if (ProgramState != Free) { Attention(0,"Another task is in progress"); return; }
ProgramState=DoingSetup; BatStop=FALSE; Setup.Hardware.AutoStopOn=FALSE;

CreateDir();                                     //Create directories as per user preferences if they dont exist already

Bat=g_new(struct Bat,1);

TitlesStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { TitlesStyle->fg[i]=TitlesStyle->text[i]=TitlesFg; TitlesStyle->bg[i]=TitlesBg; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL); PrevWin=Win; ParentWin=Win;
gtk_window_set_title(GTK_WINDOW(Win),"Batch Acquisition Setup");
gtk_widget_set_uposition(GTK_WIDGET(Win),0,TopSpace);
gtk_widget_set_size_request(GTK_WIDGET(Win),-1,300);
g_signal_connect(GTK_OBJECT(Win),"delete_event",G_CALLBACK(CloseBatchAcq),NULL);

VBox=gtk_vbox_new(FALSE,12); gtk_container_add(GTK_CONTAINER(Win),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,TRUE,TRUE,0);
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,TRUE,0);
Bat->ScrlW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Bat->ScrlW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_widget_set_size_request(GTK_WIDGET(Bat->ScrlW),520,30);
gtk_box_pack_start(GTK_BOX(VBox1),Bat->ScrlW,FALSE,FALSE,0);

Table=gtk_table_new(1,5,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Bat->ScrlW),Table);
for (i=0;i<5;++i)
    {
    TitlesBut=gtk_button_new_with_label(Titles[i]); SetStyleRecursively(TitlesBut,TitlesStyle);
    gtk_widget_set_size_request(GTK_WIDGET(TitlesBut),ColWidth[i],26);
    gtk_table_attach(GTK_TABLE(Table),TitlesBut,i,i+1,0,1,GTK_FILL,GTK_SHRINK,0,0);
    }

Bat->ScrlW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Bat->ScrlW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start(GTK_BOX(VBox1),Bat->ScrlW,TRUE,TRUE,0);

Bat->Table=gtk_table_new(Setup.BatAcq.NBat,4,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Bat->ScrlW),Bat->Table);
for (i=0;i<Setup.BatAcq.NBat;++i) MakeBatRow(i,Bat->Table);
Bat->Row=0;

VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,FALSE,FALSE,0);
But=gtk_button_new_with_label("Quick Set"); gtk_box_pack_start(GTK_BOX(VBox1),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(QuickBat),NULL);
But=gtk_button_new_with_label("Add"); gtk_box_pack_start(GTK_BOX(VBox1),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatAdd),NULL);
But=gtk_button_new_with_label("Clear"); gtk_box_pack_start(GTK_BOX(VBox1),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(BatClear),NULL);
But=gtk_button_new_with_label("Clear All"); gtk_box_pack_start(GTK_BOX(VBox1),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(BatClearAll),NULL);

HBox=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("Load Batch"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(LoadBatAcq),NULL);
But=gtk_button_new_with_label("Save Batch"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SaveBatAcq),NULL);
But=gtk_button_new_with_label("Start Batch"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StartBatAcq),Win);
But=gtk_button_new_with_label("Cancel"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(CancelBatAcq),Win);

gtk_widget_show_all(Win);
gtk_style_unref(TitlesStyle);
}
//----------------------------------------------------------------------------------------------------------------------
void BatStopAtOnce(GtkWidget *W,GtkWidget *Win)
{
StopNicely();
BatStop=TRUE; gtk_widget_destroy(Win);
strcpy(PrevRun,RunName); BatchRunning=FALSE;
pthread_cancel(CntlBat);
}
//----------------------------------------------------------------------------------------------------------------------
void BatStopAfterCurrentRun(GtkWidget *W,GtkWidget *Win)
{ BatStop=TRUE; gtk_widget_destroy(Win); }
//----------------------------------------------------------------------------------------------------------------------
void BatchTerminate(GtkWidget *W,gpointer Unused)
{
GtkWidget *Win,*BBox,*But;

if (!BatchRunning) return;
Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(Win),"Terminate");
gtk_widget_set_uposition(GTK_WIDGET(Win),0,TopSpace);
gtk_widget_set_usize(GTK_WIDGET(Win),125,150);
g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));

BBox=gtk_vbutton_box_new(); gtk_container_add(GTK_CONTAINER(Win),BBox);
gtk_container_set_border_width(GTK_CONTAINER(BBox),5);

But=gtk_button_new_with_label("Stop now");
gtk_container_add(GTK_CONTAINER(BBox),But);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatStopAtOnce),Win);

But=gtk_button_new_with_label("Stop after\ncurrent run");
gtk_container_add(GTK_CONTAINER(BBox),But);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(BatStopAfterCurrentRun),Win);

But=gtk_button_new_with_label("Cancel");
gtk_container_add(GTK_CONTAINER(BBox),But);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));

gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------

